/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.metal_processing.blast_furnace;

import com.drmangotea.tfmg.blocks.machines.TFMGMachineBlockEntity;
import com.drmangotea.tfmg.recipes.industrial_blasting.IndustrialBlastingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BlastFurnaceOutputBlockEntity
extends TFMGMachineBlockEntity
implements IHaveGoggleInformation {
    public BlastFurnaceType type;
    public Direction outputFacing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
    public BlockPos mainFloor;
    public int height = 2;
    public int reinforcementHeight = 0;
    public int validHeight = 0;
    public float blastFurnaceLevel = 0.0f;
    public float fuelEfficiency = 1000.0f;
    public float speedModifier = 1.0f;
    public int timer = -1;
    public IndustrialBlastingRecipe recipe;
    public LerpedFloat coalCokeHeight = LerpedFloat.linear();
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    public SmartInventory inputInventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().withMaxStackSize(64);
    public SmartInventory fuelInventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().withMaxStackSize(64);
    int debug = 0;

    public BlastFurnaceOutputBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.fuelInventory}));
        this.inputInventory.forbidExtraction();
        this.fuelInventory.forbidExtraction();
        this.tank1.getPrimaryHandler().setCapacity(8000);
        this.tank2.getPrimaryHandler().setCapacity(8000);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }

    public void tick() {
        super.tick();
        this.manageMoltenMetal();
        if (this.type == BlastFurnaceType.SMALL) {
            this.blastFurnaceLevel = (float)this.validHeight / 2.0f - 1.0f;
            this.blastFurnaceLevel = (float)Math.min((double)this.blastFurnaceLevel, 2.5);
        }
        if (this.type == BlastFurnaceType.BIG_LEFT || this.type == BlastFurnaceType.BIG_RIGHT) {
            this.blastFurnaceLevel = this.validHeight;
            this.blastFurnaceLevel = Math.min(this.blastFurnaceLevel, 15.0f);
        }
        if (this.speedModifier != 0.0f) {
            this.speedModifier = this.blastFurnaceLevel / 2.0f;
            this.fuelEfficiency = 400.0f * this.speedModifier;
        } else {
            this.fuelEfficiency = 400.0f;
            this.speedModifier = 1.0f;
        }
        this.outputFacing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        this.coalCokeHeight.chase((double)(this.fuelInventory.getStackInSlot(0).m_41613_() + this.inputInventory.getStackInSlot(0).m_41613_()), (double)0.1f, LerpedFloat.Chaser.EXP);
        this.coalCokeHeight.tickChaser();
        this.checkType();
        if (this.reinforcementHeight < 2) {
            this.type = BlastFurnaceType.INVALID;
            return;
        }
        if (this.type == BlastFurnaceType.INVALID) {
            return;
        }
        int maxLevelByReinforcements = this.reinforcementHeight * 2;
        this.validHeight = Math.min(maxLevelByReinforcements, this.height);
        if (this.height < 4) {
            this.type = BlastFurnaceType.INVALID;
            return;
        }
        if (this.recipe != null && this.timer == -1 && this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(0)).getAmount() <= this.tank1.getPrimaryHandler().getCapacity() && this.tank2.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(1)).getAmount() <= this.tank2.getPrimaryHandler().getCapacity() && this.type != BlastFurnaceType.INVALID && !this.fuelInventory.m_7983_()) {
            this.timer = (int)((float)this.recipe.getProcessingDuration() / this.speedModifier);
            this.inputInventory.getStackInSlot(0).m_41764_(this.inputInventory.getStackInSlot(0).m_41613_() - 1);
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInventory);
        if (this.recipe == null || !this.recipe.matches(inventoryIn, this.f_58857_)) {
            Optional recipe = TFMGRecipeTypes.INDUSTRIAL_BLASTING.find(inventoryIn, this.f_58857_);
            if (!recipe.isPresent()) {
                this.timer = -1;
                this.sendData();
            } else {
                this.recipe = (IndustrialBlastingRecipe)((Object)recipe.get());
                this.sendData();
            }
        }
        this.acceptInsertedItems();
        if (this.type != BlastFurnaceType.INVALID && this.timer > 0 && this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(0)).getAmount() <= this.tank1.getPrimaryHandler().getCapacity() && this.tank2.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(1)).getAmount() <= this.tank2.getPrimaryHandler().getCapacity()) {
            --this.timer;
            int random = Create.RANDOM.nextInt((int)Math.abs(this.fuelEfficiency) + 1);
            if (random == 69) {
                this.fuelInventory.getStackInSlot(0).m_41774_(1);
            }
        }
        if (this.timer == 0) {
            this.process();
            this.timer = -1;
        }
    }

    public void manageMoltenMetal() {
        BlockPos posToSpawn3;
        BlockPos posToSpawn2;
        BlockPos posToSpawn1;
        BlockPos posToSpawn;
        if (this.timer > 0 && this.type == BlastFurnaceType.SMALL) {
            posToSpawn = this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_();
            this.f_58857_.m_7731_(posToSpawn, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
        }
        if (this.timer > 0 && this.type == BlastFurnaceType.BIG_LEFT) {
            posToSpawn = this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_();
            posToSpawn1 = this.m_58899_().m_5484_(this.outputFacing.m_122424_(), 2).m_7494_();
            posToSpawn2 = this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_().m_121945_(this.outputFacing.m_122428_());
            posToSpawn3 = this.m_58899_().m_5484_(this.outputFacing.m_122424_(), 2).m_7494_().m_121945_(this.outputFacing.m_122428_());
            this.f_58857_.m_7731_(posToSpawn, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn1, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn2, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn3, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn1.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn2.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn3.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
        }
        if (this.timer > 0 && this.type == BlastFurnaceType.BIG_RIGHT) {
            posToSpawn = this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_();
            posToSpawn1 = this.m_58899_().m_5484_(this.outputFacing.m_122424_(), 2).m_7494_();
            posToSpawn2 = this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_().m_121945_(this.outputFacing.m_122427_());
            posToSpawn3 = this.m_58899_().m_5484_(this.outputFacing.m_122424_(), 2).m_7494_().m_121945_(this.outputFacing.m_122427_());
            this.f_58857_.m_7731_(posToSpawn, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn1, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn2, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn3, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn1.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn2.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            this.f_58857_.m_7731_(posToSpawn3.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
        }
    }

    protected AABB createRenderBoundingBox() {
        int x = this.m_58899_().m_123341_();
        int y = this.m_58899_().m_123342_();
        int z = this.m_58899_().m_123343_();
        return new AABB((double)(x - 10), (double)(y - 10), (double)(z - 10), (double)(x + 10), (double)(y + 10), (double)(z + 10));
    }

    public void process() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.tank1.getPrimaryHandler().setFluid(new FluidStack(((FluidStack)this.recipe.getFluidResults().get(0)).getFluid(), this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(0)).getAmount()));
        this.tank2.getPrimaryHandler().setFluid(new FluidStack(((FluidStack)this.recipe.getFluidResults().get(1)).getFluid(), this.tank2.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(1)).getAmount()));
    }

    public void acceptInsertedItems() {
        List<ItemEntity> itemsToPick = this.getItemsToPick(this.type);
        for (ItemEntity itemEntity : itemsToPick) {
            int freeSpace;
            ItemStack itemStack = itemEntity.m_32055_();
            if (itemStack.m_150930_((Item)TFMGItems.COAL_COKE_DUST.get())) {
                freeSpace = this.fuelInventory.getStackInSlot(0).m_41741_() - this.fuelInventory.getStackInSlot(0).m_41613_();
                int coalCokeCount = itemStack.m_41613_();
                if (coalCokeCount > freeSpace) {
                    itemStack.m_41764_(itemStack.m_41613_() - freeSpace);
                    this.fuelInventory.m_6836_(0, new ItemStack((ItemLike)TFMGItems.COAL_COKE_DUST.get(), this.fuelInventory.getStackInSlot(0).m_41613_() + freeSpace));
                    continue;
                }
                this.fuelInventory.m_6836_(0, new ItemStack((ItemLike)TFMGItems.COAL_COKE_DUST.get(), this.fuelInventory.getStackInSlot(0).m_41613_() + itemStack.m_41613_()));
                itemEntity.m_146870_();
                continue;
            }
            freeSpace = this.inputInventory.getStackInSlot(0).m_41741_() - this.inputInventory.getStackInSlot(0).m_41613_();
            int count = itemStack.m_41613_();
            if (!this.inputInventory.m_7983_() && !this.inputInventory.m_8020_(0).m_150930_(itemStack.m_41720_())) continue;
            if (count > freeSpace) {
                itemStack.m_41764_(itemStack.m_41613_() - freeSpace);
                this.inputInventory.m_6836_(0, new ItemStack((ItemLike)itemStack.m_41720_(), this.inputInventory.getStackInSlot(0).m_41613_() + freeSpace));
                continue;
            }
            this.inputInventory.m_6836_(0, new ItemStack((ItemLike)itemStack.m_41720_(), this.inputInventory.getStackInSlot(0).m_41613_() + itemStack.m_41613_()));
            itemEntity.m_146870_();
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.type == BlastFurnaceType.INVALID) {
            Lang.translate((String)"goggles.blast_furnace.invalid", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
        } else {
            Lang.translate((String)"goggles.blast_furnace.stats", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            if (this.timer > 0) {
                Lang.translate((String)"goggles.blast_furnace.status.running", (Object[])new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip, 1);
            } else {
                Lang.translate((String)"goggles.blast_furnace.status.off", (Object[])new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip, 1);
            }
            Lang.translate((String)"goggles.blast_furnace.size_stats", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
            Lang.translate((String)"goggles.blast_furnace.height", (Object[])new Object[]{this.validHeight}).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
            if (this.type == BlastFurnaceType.SMALL) {
                Lang.translate((String)"goggles.blast_furnace.diameter.one", (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
            } else {
                Lang.translate((String)"goggles.blast_furnace.diameter.two", (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
            }
            Lang.translate((String)"goggles.misc.storage_info", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
            Lang.translate((String)"goggles.blast_furnace.item_count", (Object[])new Object[]{this.inputInventory.getStackInSlot(0).m_41613_()}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            Lang.translate((String)"goggles.blast_furnace.fuel_amount", (Object[])new Object[]{this.fuelInventory.getStackInSlot(0).m_41613_()}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            Lang.translate((String)"goggles.blast_furnace.nothing_lol", (Object[])new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        LazyOptional handler = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
        this.fuelInventory.deserializeNBT(compound.m_128469_("Fuel"));
        this.timer = compound.m_128451_("Timer");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
        compound.m_128365_("Fuel", (Tag)this.fuelInventory.serializeNBT());
        compound.m_128405_("Timer", this.timer);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.itemCapability.invalidate();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void checkType() {
        this.mainFloor = this.m_58899_().m_121945_(this.outputFacing.m_122424_());
        if (!this.isValidBlock(this.mainFloor)) {
            this.type = BlastFurnaceType.INVALID;
            return;
        }
        if (this.reinforcementHeight < 2) {
            this.type = BlastFurnaceType.INVALID;
        }
        if (!this.isAboveClear(this.mainFloor)) {
            this.type = BlastFurnaceType.INVALID;
            return;
        }
        if (this.canBeSmall()) {
            this.type = BlastFurnaceType.SMALL;
        }
        if (this.canBeBigLeft()) {
            this.type = BlastFurnaceType.BIG_LEFT;
        }
        if (this.canBeBigRight()) {
            this.type = BlastFurnaceType.BIG_RIGHT;
        }
        if (!(this.canBeBigLeft() || this.canBeBigRight() || this.canBeSmall())) {
            this.type = BlastFurnaceType.INVALID;
        }
    }

    public boolean isAboveClear(BlockPos pos) {
        return this.f_58857_.m_8055_(pos = pos.m_7494_()).m_60713_(Blocks.f_50016_) || this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.MOLTEN_METAL.get());
    }

    public boolean isAboveValid(BlockPos pos) {
        return this.isAboveValid(pos, false);
    }

    public boolean isAboveValid(BlockPos pos, boolean firstCheck) {
        pos = pos.m_7494_();
        boolean isValid = this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.FIREPROOF_BRICKS.get());
        BlockPos pos1 = pos.m_7494_();
        int height = 2;
        for (int i = 0; i < 8 && this.f_58857_.m_8055_(pos1).m_60713_((Block)TFMGBlocks.FIREPROOF_BRICKS.get()); ++i) {
            ++height;
            pos1 = pos1.m_7494_();
        }
        if (height <= this.height || firstCheck) {
            this.height = height;
        }
        return isValid;
    }

    public void isReinforcement(BlockPos pos) {
        this.isReinforcement(pos, false);
    }

    public void isReinforcement(BlockPos pos, boolean firstCheck) {
        BlockPos pos1 = pos;
        int height = 0;
        for (int i = 0; i < 8 && this.f_58857_.m_8055_(pos1).m_60713_((Block)TFMGBlocks.FIREPROOF_BRICK_REINFORCEMENT.get()); ++i) {
            ++height;
            pos1 = pos1.m_7494_();
        }
        if (height <= this.reinforcementHeight || firstCheck) {
            this.reinforcementHeight = height;
        }
    }

    public boolean isValidBlock(BlockPos pos) {
        return this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.FIREPROOF_BRICKS.get());
    }

    public boolean canBeSmall() {
        BlockPos checkedPos = this.m_58899_().m_121945_(this.outputFacing.m_122424_());
        BlockPos mainPos = checkedPos;
        if (!this.isValidBlock(mainPos)) {
            return false;
        }
        if (!this.isAboveClear(mainPos)) {
            return false;
        }
        checkedPos = mainPos.m_121945_(this.outputFacing.m_122427_());
        if (!this.isValidBlock(checkedPos)) {
            return false;
        }
        if (!this.isAboveValid(checkedPos, true)) {
            return false;
        }
        checkedPos = mainPos.m_121945_(this.outputFacing.m_122428_());
        if (!this.isValidBlock(checkedPos)) {
            return false;
        }
        if (!this.isAboveValid(checkedPos)) {
            return false;
        }
        checkedPos = mainPos.m_121945_(this.outputFacing.m_122424_());
        if (!this.isValidBlock(checkedPos)) {
            return false;
        }
        if (!this.isAboveValid(checkedPos)) {
            return false;
        }
        checkedPos = mainPos.m_121945_(this.outputFacing);
        if (!this.isAboveValid(checkedPos)) {
            return false;
        }
        this.isReinforcement(checkedPos.m_121945_(this.outputFacing.m_122428_()), true);
        this.isReinforcement(checkedPos.m_121945_(this.outputFacing.m_122427_()));
        this.isReinforcement(mainPos.m_121945_(this.outputFacing.m_122424_()).m_121945_(this.outputFacing.m_122428_()));
        this.isReinforcement(mainPos.m_121945_(this.outputFacing.m_122424_()).m_121945_(this.outputFacing.m_122427_()));
        return true;
    }

    public boolean canBeBigRight() {
        this.mainFloor = this.m_58899_().m_121945_(this.outputFacing.m_122424_());
        BlockPos checkedPos = this.m_58899_().m_121945_(this.outputFacing.m_122428_());
        for (int i = 0; i < 4; ++i) {
            for (int y = 0; y < 4; ++y) {
                if (!(i == 0 && y == 0 || i == 3 && y == 3 || i == 0 && y == 3 || i == 3 && y == 0)) {
                    if (i == 1 && y == 0) {
                        if (this.isAboveValid(checkedPos)) {
                            checkedPos = checkedPos.m_121945_(this.outputFacing.m_122424_());
                            continue;
                        }
                        return false;
                    }
                    if (!this.isValidBlock(checkedPos)) {
                        return false;
                    }
                    if (i == 0 && y == 1 && !this.isAboveValid(checkedPos, true)) {
                        return false;
                    }
                    if (i == 0 || i == 3 || y == 0 || y == 3 ? !this.isAboveValid(checkedPos) : !this.isAboveClear(checkedPos)) {
                        return false;
                    }
                } else {
                    if (i == 0 && y == 0) {
                        this.isReinforcement(checkedPos, true);
                    }
                    this.isReinforcement(checkedPos);
                }
                checkedPos = checkedPos.m_121945_(this.outputFacing.m_122424_());
            }
            checkedPos = checkedPos.m_5484_(this.outputFacing, 4);
            checkedPos = checkedPos.m_121945_(this.outputFacing.m_122427_());
        }
        return true;
    }

    public boolean canBeBigLeft() {
        this.mainFloor = this.m_58899_().m_121945_(this.outputFacing.m_122424_());
        BlockPos checkedPos = this.m_58899_().m_121945_(this.outputFacing.m_122427_());
        for (int i = 0; i < 4; ++i) {
            for (int y = 0; y < 4; ++y) {
                if (!(i == 0 && y == 0 || i == 3 && y == 3 || i == 0 && y == 3 || i == 3 && y == 0)) {
                    if (i == 1 && y == 0) {
                        if (this.isAboveValid(checkedPos)) {
                            checkedPos = checkedPos.m_121945_(this.outputFacing.m_122424_());
                            continue;
                        }
                        return false;
                    }
                    if (!this.isValidBlock(checkedPos)) {
                        return false;
                    }
                    if (i == 0 && y == 1 && !this.isAboveValid(checkedPos, true)) {
                        return false;
                    }
                    if (i == 0 || i == 3 || y == 0 || y == 3 ? !this.isAboveValid(checkedPos) : !this.isAboveClear(checkedPos)) {
                        return false;
                    }
                } else {
                    if (i == 0 && y == 0) {
                        this.isReinforcement(checkedPos, true);
                    }
                    this.isReinforcement(checkedPos);
                }
                checkedPos = checkedPos.m_121945_(this.outputFacing.m_122424_());
            }
            checkedPos = checkedPos.m_5484_(this.outputFacing, 4);
            checkedPos = checkedPos.m_121945_(this.outputFacing.m_122428_());
        }
        return true;
    }

    public List<ItemEntity> getItemsToPick(BlastFurnaceType type) {
        AABB searchArea = null;
        AABB searchArea1 = null;
        AABB searchArea2 = null;
        AABB searchArea3 = null;
        if (type == BlastFurnaceType.SMALL) {
            searchArea = new AABB(this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_());
        }
        if (type == BlastFurnaceType.BIG_RIGHT) {
            searchArea = new AABB(this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_());
            searchArea1 = new AABB(this.m_58899_().m_5484_(this.outputFacing.m_122424_(), 2).m_7494_());
            searchArea2 = new AABB(this.m_58899_().m_5484_(this.outputFacing.m_122424_(), 2).m_7494_().m_121945_(this.outputFacing.m_122427_()));
            searchArea3 = new AABB(this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_().m_121945_(this.outputFacing.m_122427_()));
        }
        if (type == BlastFurnaceType.BIG_LEFT) {
            searchArea = new AABB(this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_());
            searchArea1 = new AABB(this.m_58899_().m_5484_(this.outputFacing.m_122424_(), 2).m_7494_());
            searchArea2 = new AABB(this.m_58899_().m_5484_(this.outputFacing.m_122424_(), 2).m_7494_().m_121945_(this.outputFacing.m_122428_()));
            searchArea3 = new AABB(this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_().m_121945_(this.outputFacing.m_122428_()));
        }
        if (searchArea1 != null) {
            ArrayList<ItemEntity> itemList = new ArrayList<ItemEntity>();
            itemList.addAll(this.f_58857_.m_45976_(ItemEntity.class, searchArea));
            itemList.addAll(this.f_58857_.m_45976_(ItemEntity.class, searchArea1));
            itemList.addAll(this.f_58857_.m_45976_(ItemEntity.class, searchArea2));
            itemList.addAll(this.f_58857_.m_45976_(ItemEntity.class, searchArea3));
            return itemList;
        }
        return this.f_58857_.m_45976_(ItemEntity.class, searchArea);
    }

    public static enum BlastFurnaceType {
        SMALL,
        BIG_LEFT,
        BIG_RIGHT,
        INVALID;

    }
}

