/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.fertilizer;

import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.data.recipes.fertilizer.Fertilizer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BasicFertilizer
extends Fertilizer {
    protected Ingredient ingredient;
    @Nullable
    protected Ingredient cropIngredient;
    @Nullable
    protected Ingredient soilIngredient;
    protected int minTicks;
    protected int maxTicks;

    public BasicFertilizer(ResourceLocation id, Ingredient ingredient, @Nullable Ingredient cropIngredient, @Nullable Ingredient soilIngredient, int minTicks, int maxTicks) {
        super(id);
        this.ingredient = ingredient;
        this.cropIngredient = cropIngredient;
        this.soilIngredient = soilIngredient;
        this.minTicks = minTicks;
        this.maxTicks = maxTicks;
    }

    @Override
    public boolean canApply(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, BlockEntityBotanyPot pot) {
        return !(!this.ingredient.test(heldStack) || this.cropIngredient != null && !this.cropIngredient.test(((BotanyPotContainer)pot.getInventory()).getCropStack()) || this.soilIngredient != null && !this.soilIngredient.test(((BotanyPotContainer)pot.getInventory()).getSoilStack()));
    }

    @Override
    public void apply(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, BlockEntityBotanyPot pot) {
        if (!world.f_46443_) {
            pot.addGrowth(world.f_46441_.m_216332_(this.minTicks, this.maxTicks));
            world.m_46796_(1505, pos, 0);
            if (!player.m_7500_()) {
                heldStack.m_41774_(1);
            }
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BotanyPotHelper.BASIC_FERTILIZER_SERIALIZER.get();
    }
}

