/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.ForceChangeOwnerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.ObjectUtils;

public class ForceChangeOwnerPacket
extends DogPacket<ForceChangeOwnerData> {
    @Override
    public void encode(ForceChangeOwnerData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
    }

    @Override
    public ForceChangeOwnerData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        return new ForceChangeOwnerData(id);
    }

    @Override
    public void handleDog(Dog dog, ForceChangeOwnerData data, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        if (!sender.m_20310_(4)) {
            return;
        }
        if (!sender.m_150110_().f_35937_) {
            return;
        }
        ItemStack stack = sender.m_21205_();
        if (!stack.m_150930_((Item)DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        if (sender.m_36335_().m_41519_((Item)DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID currentOwnerUUID = dog.m_21805_();
        UUID newOwnerUUID = sender.m_20148_();
        if (newOwnerUUID == null) {
            return;
        }
        if (!ObjectUtils.notEqual((Object)newOwnerUUID, (Object)currentOwnerUUID)) {
            return;
        }
        dog.migrateOwner(newOwnerUUID);
        sender.m_36335_().m_41524_((Item)DoggyItems.AMNESIA_BONE.get(), 40);
    }
}

