/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogFetchAction;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ThrowableItem
extends Item
implements IThrowableItem {
    public Supplier<? extends Item> altBone;
    public Supplier<? extends Item> renderBone;

    public ThrowableItem(Supplier<? extends Item> altBone, Supplier<? extends Item> renderBone, Item.Properties properties) {
        super(properties);
        this.altBone = altBone;
        this.renderBone = renderBone;
    }

    @Override
    public ItemStack getReturnStack(ItemStack stack) {
        ItemStack returnStack = new ItemStack((ItemLike)this.altBone.get());
        if (stack.m_41782_()) {
            returnStack.m_41751_(stack.m_41783_().m_6426_());
        }
        return returnStack;
    }

    @Override
    public ItemStack getCustomRenderStack(ItemStack stack) {
        return new ItemStack((ItemLike)this.renderBone.get());
    }

    public void setHeadingFromThrower(ItemEntity entityItem, Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.setThrowableHeading(entityItem, f, f1, f2, velocity, inaccuracy);
        Vec3 vec3d = entityThrower.m_20184_();
        entityItem.m_20256_(entityItem.m_20184_().m_82520_(vec3d.f_82479_, entityThrower.m_20096_() ? 0.0 : vec3d.f_82480_, vec3d.f_82481_));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemStackIn = playerIn.m_21120_(handIn);
        worldIn.m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 0.5f, 0.4f / (worldIn.f_46441_.m_188501_() * 0.4f + 0.8f));
        if (!worldIn.f_46443_) {
            ItemStack stack = itemStackIn.m_41777_();
            stack.m_41764_(1);
            ItemEntity entityitem = new ItemEntity(playerIn.m_9236_(), playerIn.m_20185_(), playerIn.m_20186_() - (double)0.3f + (double)playerIn.m_20192_(), playerIn.m_20189_(), stack);
            entityitem.m_32010_(20);
            this.setHeadingFromThrower(entityitem, (Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), 0.0f, 1.2f, 1.0f);
            worldIn.m_7967_((Entity)entityitem);
            this.triggerNearbyDogs(playerIn, entityitem);
        }
        if (!playerIn.m_150110_().f_35937_) {
            itemStackIn.m_41774_(1);
        }
        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
    }

    private void triggerNearbyDogs(@Nonnull Player player, @Nonnull ItemEntity entityitem) {
        int RADIUS = 5;
        List dogs = player.m_9236_().m_6443_(Dog.class, player.m_20191_().m_82377_(5.0, 3.0, 5.0), d -> d.canInteract((LivingEntity)player) && !d.isBusy() && !d.hasBone() && !d.m_21827_() && d.getMode() == EnumMode.DOCILE);
        for (Dog dog : dogs) {
            dog.triggerAction(new DogFetchAction(dog, (LivingEntity)player, entityitem));
        }
    }

    public void setThrowableHeading(ItemEntity entityItem, double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec3d = new Vec3(x, y, z).m_82541_().m_82520_(entityItem.m_9236_().f_46441_.m_188583_() * (double)0.0075f * (double)inaccuracy, entityItem.m_9236_().f_46441_.m_188583_() * (double)0.0075f * (double)inaccuracy, entityItem.m_9236_().f_46441_.m_188583_() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        entityItem.m_20256_(vec3d);
        float f = Mth.m_14116_((float)((float)(vec3d.f_82479_ * vec3d.f_82479_ + vec3d.f_82481_ * vec3d.f_82481_)));
        entityItem.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_) * 57.2957763671875));
        entityItem.m_146926_((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)f) * 57.2957763671875));
        entityItem.f_19859_ = entityItem.m_146908_();
        entityItem.f_19860_ = entityItem.m_146909_();
    }
}

