/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Piano
extends Entity {
    private static final EntityDataAccessor<Integer> PIANO_FLAGS = SynchedEntityData.m_135353_(Piano.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final PianoType pianoType;
    private final PianoColor pianoColor;

    public Piano(EntityType<Piano> type, Level level) {
        super(type, level);
        this.pianoType = PianoType.GRAND;
        this.pianoColor = PianoColor.BLACK;
    }

    public Piano(EntityType<Piano> type, Level level, PianoType pianoType, PianoColor pianoColor) {
        super(type, level);
        this.pianoType = pianoType;
        this.pianoColor = pianoColor;
        this.m_146922_(0.0f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PIANO_FLAGS, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        boolean bigLidClosed = compound.m_128471_("pianoFallboardClosed");
        this.setFallboardClosed(bigLidClosed);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("pianoFallboardClosed", this.isFallboardClosed());
    }

    private boolean getPianoFlag(int bit) {
        return ((Integer)this.f_19804_.m_135370_(PIANO_FLAGS) & bit) != 0;
    }

    private void setPianoFlag(int bits, boolean flag) {
        int c = (Integer)this.f_19804_.m_135370_(PIANO_FLAGS);
        this.f_19804_.m_135381_(PIANO_FLAGS, (Object)(flag ? c | bits : c & ~bits));
    }

    public boolean isFallboardClosed() {
        return this.getPianoFlag(1);
    }

    public void setFallboardClosed(boolean val) {
        this.setPianoFlag(1, val);
    }

    public boolean m_6673_(DamageSource source) {
        return !(source.m_7640_() instanceof Player);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_21515_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_6673_(source)) {
            return false;
        }
        killer = source.m_7640_();
        if (!(killer instanceof Player)) ** GOTO lbl-1000
        player = (Player)killer;
        if (player.m_150110_().f_35937_) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        killedByCreative = v0;
        drop = this.getPianoDrop();
        if (!drop.m_41619_() && !killedByCreative) {
            this.m_19983_(drop);
        }
        this.m_146870_();
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item == Items.f_42000_) {
            if (!this.m_9236_().f_46443_ && player.m_6144_()) {
                this.m_146922_(this.m_146908_() + 45.0f);
            }
            return InteractionResult.SUCCESS;
        }
        this.setFallboardClosed(!this.isFallboardClosed());
        return InteractionResult.SUCCESS;
    }

    public ItemStack getPianoDrop() {
        EntityType type = this.m_6095_();
        Item item = null;
        if (type == DoggyEntityTypes.GRAND_PIANO_BLACK.get()) {
            item = (Item)DoggyItems.GRAND_PIANO_BLACK.get();
        } else if (type == DoggyEntityTypes.GRAND_PIANO_WHITE.get()) {
            item = (Item)DoggyItems.GRAND_PIANO_WHITE.get();
        } else if (type == DoggyEntityTypes.UPRIGHT_PIANO_BLACK.get()) {
            item = (Item)DoggyItems.UPRIGHT_PIANO_BLACK.get();
        } else if (type == DoggyEntityTypes.UPRIGHT_PIANO_BROWN.get()) {
            item = (Item)DoggyItems.UPRIGHT_PIANO_BROWN.get();
        }
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item);
    }

    public PianoType getPianoType() {
        return this.pianoType;
    }

    public PianoColor getPianoColor() {
        return this.pianoColor;
    }

    public static enum PianoType {
        GRAND,
        UPRIGHT;

    }

    public static enum PianoColor {
        BLACK,
        WHITE,
        BROWN;

    }
}

