/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.EntityUtil;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class DogFetchAction
extends TriggerableAction {
    @Nonnull
    private final ItemEntity fetchTarget;
    @Nonnull
    private final LivingEntity owner;
    private final int MIN_DIST = 2;
    private final int MAX_DIST = 32;
    private boolean isBringingBack = false;
    private int tickTillPathRecalc = 1;
    private float oldWaterCost;
    private double oldRangeSense;
    private boolean initFetch;

    public DogFetchAction(Dog dog, @Nonnull LivingEntity owner, @Nonnull ItemEntity fetchTarget) {
        super(dog, true, true);
        this.fetchTarget = fetchTarget;
        this.owner = owner;
    }

    @Override
    public void onStart() {
        if (this.dog.hasBone() || this.dog.getMode() != EnumMode.DOCILE) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.tickTillPathRecalc = 1;
        this.isBringingBack = false;
        this.initFetch();
    }

    @Override
    public void tick() {
        if (!this.owner.m_6084_() || this.owner.m_5833_()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!this.isBringingBack) {
            if (!this.canFetchStack(this.fetchTarget)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.hasBone()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        } else if (!this.dog.hasBone()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (--this.tickTillPathRecalc < 0) {
            this.tickTillPathRecalc = 20;
        }
        if (!this.isBringingBack) {
            this.goGetFetchItem();
        } else if (this.bringBackFetchItem()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    @Override
    public void onStop() {
        this.dropFetchItem();
        this.finishFetch();
    }

    private void initFetch() {
        this.tickTillPathRecalc = 1;
        this.oldWaterCost = this.dog.m_21439_(BlockPathTypes.WATER);
        this.dog.setDogFollowingSomeone(true);
        AttributeInstance attrib = this.dog.m_21051_(Attributes.f_22277_);
        if (attrib == null) {
            return;
        }
        this.oldRangeSense = attrib.m_22135_();
        attrib.m_22100_((double)this.MAX_DIST);
        this.initFetch = true;
    }

    private void finishFetch() {
        if (!this.initFetch) {
            return;
        }
        this.dog.m_21573_().m_26573_();
        this.dog.setDogFollowingSomeone(false);
        AttributeInstance attrib = this.dog.m_21051_(Attributes.f_22277_);
        if (attrib == null) {
            return;
        }
        attrib.m_22100_(this.oldRangeSense);
    }

    private void goGetFetchItem() {
        this.dog.m_21563_().m_24960_((Entity)this.fetchTarget, 10.0f, (float)this.dog.m_8132_());
        if (this.tickTillPathRecalc <= 0) {
            this.dog.m_21573_().m_5624_((Entity)this.fetchTarget, 1.0);
        }
        this.checkAndGetFetchItem();
    }

    private boolean bringBackFetchItem() {
        this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
        if (this.dog.m_20280_((Entity)this.owner) <= 4.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return true;
        }
        if (this.tickTillPathRecalc > 0) {
            return false;
        }
        this.dog.m_21573_().m_5624_((Entity)this.owner, 1.0);
        return false;
    }

    private boolean checkAndGetFetchItem() {
        if (!this.dog.hasBone() && this.dog.m_20270_((Entity)this.fetchTarget) < (float)(this.MIN_DIST * this.MIN_DIST) && this.fetchTarget.m_6084_() && !this.fetchTarget.m_32063_()) {
            this.dog.setBoneVariant(this.fetchTarget.m_32055_());
            this.fetchTarget.m_146870_();
            this.isBringingBack = true;
            this.tickTillPathRecalc = 1;
            this.dog.m_21573_().m_26573_();
            return true;
        }
        return false;
    }

    private void dropFetchItem() {
        if (this.dog.hasBone()) {
            IThrowableItem throwableItem = this.dog.getThrowableItem();
            ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
            this.dog.m_5552_(fetchItem, 0.0f);
            this.dog.setBoneVariant(ItemStack.f_41583_);
        }
    }

    private boolean canFetchStack(ItemEntity e) {
        if (!e.m_6084_() || e.m_20145_()) {
            return false;
        }
        if ((double)e.m_20270_((Entity)this.dog) > EntityUtil.getFollowRange((LivingEntity)this.dog)) {
            return false;
        }
        return e.m_32055_().m_41720_() instanceof IThrowableItem;
    }
}

