/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.animation;

import doggytalents.client.entity.model.AnimatedSyncedAccessoryModel;
import doggytalents.client.entity.model.animation.SimpleAnimatedModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class KeyframeAnimationsDelegate {
    public static void animate(DogModel model, Dog dog, AnimationDefinition animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        float elapsed_in_seconds = KeyframeAnimationsDelegate.getElapsedSeconds(animation, elapsed_in_millis);
        for (Map.Entry entry : animation.f_232257_().entrySet()) {
            Optional<ModelPart> partOptional = model.searchForPartWithName((String)entry.getKey());
            if (partOptional.isEmpty()) continue;
            ModelPart part = partOptional.get();
            model.resetPart(part, dog);
            List channelList = (List)entry.getValue();
            for (AnimationChannel channel : channelList) {
                Keyframe[] keyframes = channel.f_232212_();
                int currentKeyframeIndx = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, compare_indx -> elapsed_in_seconds <= keyframes[compare_indx].f_232283_()) - 1);
                int nextKeyframeIndx = Math.min(keyframes.length - 1, currentKeyframeIndx + 1);
                Keyframe currentKeyframe = keyframes[currentKeyframeIndx];
                Keyframe nextKeyframe = keyframes[nextKeyframeIndx];
                float passed_time_since_current = elapsed_in_seconds - currentKeyframe.f_232283_();
                float duration_between = nextKeyframe.f_232283_() - currentKeyframe.f_232283_();
                float passed_progress = 0.0f;
                if (duration_between > 0.0f) {
                    passed_progress = Mth.m_14036_((float)(passed_time_since_current / duration_between), (float)0.0f, (float)1.0f);
                }
                nextKeyframe.f_232285_().m_232222_(temp_buffer, passed_progress, keyframes, currentKeyframeIndx, nextKeyframeIndx, interpolation_scale);
                channel.f_232211_().m_232247_(part, temp_buffer);
                model.adjustAnimatedPart(part, dog);
            }
        }
    }

    public static void animate(AnimatedSyncedAccessoryModel model, Dog dog, AnimationDefinition animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        float elapsed_in_seconds = KeyframeAnimationsDelegate.getElapsedSeconds(animation, elapsed_in_millis);
        for (Map.Entry entry : animation.f_232257_().entrySet()) {
            Optional<ModelPart> partOptional = model.searchForPartWithName((String)entry.getKey());
            if (partOptional.isEmpty()) continue;
            ModelPart part = partOptional.get();
            model.resetPart(part, dog);
            List channelList = (List)entry.getValue();
            for (AnimationChannel channel : channelList) {
                Keyframe[] keyframes = channel.f_232212_();
                int currentKeyframeIndx = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, compare_indx -> elapsed_in_seconds <= keyframes[compare_indx].f_232283_()) - 1);
                int nextKeyframeIndx = Math.min(keyframes.length - 1, currentKeyframeIndx + 1);
                Keyframe currentKeyframe = keyframes[currentKeyframeIndx];
                Keyframe nextKeyframe = keyframes[nextKeyframeIndx];
                float passed_time_since_current = elapsed_in_seconds - currentKeyframe.f_232283_();
                float duration_between = nextKeyframe.f_232283_() - currentKeyframe.f_232283_();
                float passed_progress = 0.0f;
                if (duration_between > 0.0f) {
                    passed_progress = Mth.m_14036_((float)(passed_time_since_current / duration_between), (float)0.0f, (float)1.0f);
                }
                nextKeyframe.f_232285_().m_232222_(temp_buffer, passed_progress, keyframes, currentKeyframeIndx, nextKeyframeIndx, interpolation_scale);
                channel.f_232211_().m_232247_(part, temp_buffer);
            }
        }
    }

    public static void animateSimple(SimpleAnimatedModel model, AnimationDefinition animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        float elapsed_in_seconds = KeyframeAnimationsDelegate.getElapsedSeconds(animation, elapsed_in_millis);
        for (Map.Entry entry : animation.f_232257_().entrySet()) {
            Optional<ModelPart> partOptional = model.getPartFromName((String)entry.getKey());
            if (partOptional.isEmpty()) continue;
            ModelPart part = partOptional.get();
            model.resetPart(part);
            List channelList = (List)entry.getValue();
            for (AnimationChannel channel : channelList) {
                Keyframe[] keyframes = channel.f_232212_();
                int currentKeyframeIndx = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, compare_indx -> elapsed_in_seconds <= keyframes[compare_indx].f_232283_()) - 1);
                int nextKeyframeIndx = Math.min(keyframes.length - 1, currentKeyframeIndx + 1);
                Keyframe currentKeyframe = keyframes[currentKeyframeIndx];
                Keyframe nextKeyframe = keyframes[nextKeyframeIndx];
                float passed_time_since_current = elapsed_in_seconds - currentKeyframe.f_232283_();
                float duration_between = nextKeyframe.f_232283_() - currentKeyframe.f_232283_();
                float passed_progress = 0.0f;
                if (duration_between > 0.0f) {
                    passed_progress = Mth.m_14036_((float)(passed_time_since_current / duration_between), (float)0.0f, (float)1.0f);
                }
                nextKeyframe.f_232285_().m_232222_(temp_buffer, passed_progress, keyframes, currentKeyframeIndx, nextKeyframeIndx, interpolation_scale);
                channel.f_232211_().m_232247_(part, temp_buffer);
            }
        }
    }

    public static float getCurrentAnimatedYRot(Dog dog, AnimationDefinition animation, long elapsed_in_millis, float interpolation_scale) {
        float elapsed_in_seconds = KeyframeAnimationsDelegate.getElapsedSeconds(animation, elapsed_in_millis);
        List rootChannelList = (List)animation.f_232257_().get("root");
        if (rootChannelList == null || rootChannelList.isEmpty()) {
            return 0.0f;
        }
        AnimationChannel rotationChannel = null;
        for (AnimationChannel channel : rootChannelList) {
            if (channel.f_232211_() != AnimationChannel.Targets.f_232251_) continue;
            rotationChannel = channel;
        }
        if (rotationChannel == null) {
            return 0.0f;
        }
        Keyframe[] keyframes = rotationChannel.f_232212_();
        int currentKeyframeIndx = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, compare_indx -> elapsed_in_seconds <= keyframes[compare_indx].f_232283_()) - 1);
        int nextKeyframeIndx = Math.min(keyframes.length - 1, currentKeyframeIndx + 1);
        Keyframe currentKeyframe = keyframes[currentKeyframeIndx];
        Keyframe nextKeyframe = keyframes[nextKeyframeIndx];
        float passed_time_since_current = elapsed_in_seconds - currentKeyframe.f_232283_();
        float duration_between = nextKeyframe.f_232283_() - currentKeyframe.f_232283_();
        float passed_progress = 0.0f;
        if (duration_between > 0.0f) {
            passed_progress = Mth.m_14036_((float)(passed_time_since_current / duration_between), (float)0.0f, (float)1.0f);
        }
        Vector3f result = new Vector3f(0.0f, 0.0f, 0.0f);
        nextKeyframe.f_232285_().m_232222_(result, passed_progress, keyframes, currentKeyframeIndx, nextKeyframeIndx, interpolation_scale);
        return result.y;
    }

    private static float getElapsedSeconds(AnimationDefinition animation, long raw_seconds) {
        float f = (float)raw_seconds / 1000.0f;
        return animation.f_232256_() ? f % animation.f_232255_() : f;
    }
}

