/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.feature;

public class DogLevel {
    private int level;
    private int kamiLevel;

    public DogLevel(int level, int kami) {
        this.level = level;
        this.kamiLevel = kami;
    }

    public int getLevel(Type type) {
        return type == Type.KAMI ? this.kamiLevel : this.level;
    }

    public boolean canIncrease(Type type) {
        return type == Type.KAMI ? this.level >= 60 : true;
    }

    @Deprecated
    public void setLevel(Type type, int level) {
        if (type == Type.KAMI) {
            this.kamiLevel = level;
        } else {
            this.level = level;
        }
    }

    @Deprecated
    public void incrementLevel(Type type) {
        this.setLevel(type, this.getLevel(type) + 1);
    }

    public float getMaxHealth() {
        int hearts = 10 + (int)Math.ceil(0.16666667f * (float)this.level + 0.33333334f * (float)this.kamiLevel);
        return 2 * hearts;
    }

    public DogLevel copy() {
        return new DogLevel(this.level, this.kamiLevel);
    }

    public DogLevel combine(DogLevel levelIn) {
        int combinedLevel = this.getLevel(Type.NORMAL) + levelIn.getLevel(Type.NORMAL);
        combinedLevel /= 2;
        combinedLevel = Math.min(combinedLevel, 20);
        return new DogLevel(combinedLevel, 0);
    }

    public final boolean isFullKami() {
        return this.kamiLevel >= 30;
    }

    public static enum Type {
        NORMAL("normal_treat"),
        KAMI("kami_treat");

        String n;

        private Type(String n2) {
            this.n = n2;
        }

        public String getName() {
            return this.n;
        }
    }
}

