/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.blockentities;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingSimulationRequester;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.util.AECableType;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.CraftJob;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.MeBridgeEntityListener;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.MeBridgePeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import de.srendi.advancedperipherals.common.setup.Blocks;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeBridgeEntity
extends PeripheralBlockEntity<MeBridgePeripheral>
implements IActionSource,
IActionHost,
IInWorldGridNodeHost,
ICraftingSimulationRequester {
    private final List<CraftJob> jobs = new CopyOnWriteArrayList<CraftJob>();
    private boolean initialized = false;
    private final IManagedGridNode mainNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)MeBridgeEntityListener.INSTANCE);

    public MeBridgeEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.ME_BRIDGE.get(), pos, state);
    }

    @Override
    @NotNull
    protected MeBridgePeripheral createPeripheral() {
        return new MeBridgePeripheral(this);
    }

    @Override
    public <T extends BlockEntity> void handleTick(Level level, BlockState state, BlockEntityType<T> type) {
        if (!this.f_58857_.f_46443_) {
            if (!this.initialized) {
                this.mainNode.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
                this.mainNode.setIdlePowerUsage((double)((Integer)APConfig.PERIPHERALS_CONFIG.meConsumption.get()).intValue());
                this.mainNode.setVisualRepresentation(new ItemStack((ItemLike)Blocks.ME_BRIDGE.get()));
                this.mainNode.setInWorldNode(true);
                this.mainNode.create(level, this.m_58899_());
                if (this.peripheral == null) {
                    this.peripheral = this.createPeripheral();
                }
                ((MeBridgePeripheral)this.peripheral).setNode(this.mainNode);
                this.initialized = true;
            }
            this.jobs.forEach(CraftJob::maybeCraft);
            this.jobs.removeIf(CraftJob::isCraftingStarted);
        }
    }

    @NotNull
    public Optional<Player> player() {
        return Optional.empty();
    }

    @NotNull
    public Optional<IActionHost> machine() {
        return Optional.of(this);
    }

    @NotNull
    public <T> Optional<T> context(@NotNull Class<T> key) {
        return Optional.empty();
    }

    @Nullable
    public IGridNode getActionableNode() {
        return this.mainNode.getNode();
    }

    public void m_7651_() {
        super.m_7651_();
        this.mainNode.destroy();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.mainNode.destroy();
    }

    @Nullable
    public IGridNode getGridNode(@NotNull Direction dir) {
        return this.getActionableNode();
    }

    @NotNull
    public AECableType getCableConnectionType(@NotNull Direction dir) {
        return AECableType.SMART;
    }

    @Nullable
    public IActionSource getActionSource() {
        return this;
    }

    public void addJob(CraftJob job) {
        this.jobs.add(job);
    }
}

