/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.items.AbstractComputerItem;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.util.NBTUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class TurtleItem
extends AbstractComputerItem
implements IColouredItem {
    public static final CauldronInteraction CAULDRON_INTERACTION = (blockState, level, pos, player, hand, stack) -> {
        if (IColouredItem.getColourBasic(stack) == -1) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            IColouredItem.setColourBasic(stack, -1);
            LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)level, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };

    public TurtleItem(TurtleBlock block, Item.Properties settings) {
        super(block, settings);
    }

    public ItemStack create(int id, @Nullable String label, int colour, @Nullable UpgradeData<ITurtleUpgrade> leftUpgrade, @Nullable UpgradeData<ITurtleUpgrade> rightUpgrade, int fuelLevel, @Nullable ResourceLocation overlay) {
        CompoundTag tag;
        ItemStack stack = new ItemStack((ItemLike)this);
        if (label != null) {
            stack.m_41714_((Component)Component.m_237113_((String)label));
        }
        if (id >= 0) {
            stack.m_41784_().m_128405_("ComputerId", id);
        }
        IColouredItem.setColourBasic(stack, colour);
        if (fuelLevel > 0) {
            stack.m_41784_().m_128405_("Fuel", fuelLevel);
        }
        if (overlay != null) {
            stack.m_41784_().m_128359_("Overlay", overlay.toString());
        }
        if (leftUpgrade != null) {
            tag = stack.m_41784_();
            tag.m_128359_("LeftUpgrade", leftUpgrade.upgrade().getUpgradeID().toString());
            if (!leftUpgrade.data().m_128456_()) {
                tag.m_128365_("LeftUpgradeNbt", (Tag)leftUpgrade.data().m_6426_());
            }
        }
        if (rightUpgrade != null) {
            tag = stack.m_41784_();
            tag.m_128359_("RightUpgrade", rightUpgrade.upgrade().getUpgradeID().toString());
            if (!rightUpgrade.data().m_128456_()) {
                tag.m_128365_("RightUpgradeNbt", (Tag)rightUpgrade.data().m_6426_());
            }
        }
        return stack;
    }

    public Component m_7626_(ItemStack stack) {
        String baseString = this.m_5671_(stack);
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.LEFT);
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.RIGHT);
        if (left != null && right != null) {
            return Component.m_237110_((String)(baseString + ".upgraded_twice"), (Object[])new Object[]{Component.m_237115_((String)right.getUnlocalisedAdjective()), Component.m_237115_((String)left.getUnlocalisedAdjective())});
        }
        if (left != null) {
            return Component.m_237110_((String)(baseString + ".upgraded"), (Object[])new Object[]{Component.m_237115_((String)left.getUnlocalisedAdjective())});
        }
        if (right != null) {
            return Component.m_237110_((String)(baseString + ".upgraded"), (Object[])new Object[]{Component.m_237115_((String)right.getUnlocalisedAdjective())});
        }
        return Component.m_237115_((String)baseString);
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        String mod;
        String mod2;
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.LEFT);
        if (left != null && (mod2 = TurtleUpgrades.instance().getOwner(left)) != null && !mod2.equals("computercraft")) {
            return mod2;
        }
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.RIGHT);
        if (right != null && (mod = TurtleUpgrades.instance().getOwner(right)) != null && !mod.equals("computercraft")) {
            return mod;
        }
        return "computercraft";
    }

    @Override
    public ItemStack changeItem(ItemStack stack, Item newItem) {
        ItemStack itemStack;
        if (newItem instanceof TurtleItem) {
            TurtleItem turtle = (TurtleItem)newItem;
            itemStack = turtle.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), this.getUpgradeWithData(stack, TurtleSide.LEFT), this.getUpgradeWithData(stack, TurtleSide.RIGHT), this.getFuelLevel(stack), this.getOverlay(stack));
        } else {
            itemStack = ItemStack.f_41583_;
        }
        return itemStack;
    }

    @Nullable
    public ITurtleUpgrade getUpgrade(ItemStack stack, TurtleSide side) {
        String key;
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        String string = key = side == TurtleSide.LEFT ? "LeftUpgrade" : "RightUpgrade";
        if (!tag.m_128441_(key)) {
            return null;
        }
        return TurtleUpgrades.instance().get(tag.m_128461_(key));
    }

    @Nullable
    public UpgradeData<ITurtleUpgrade> getUpgradeWithData(ItemStack stack, TurtleSide side) {
        String key;
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        String string = key = side == TurtleSide.LEFT ? "LeftUpgrade" : "RightUpgrade";
        if (!tag.m_128441_(key)) {
            return null;
        }
        ITurtleUpgrade upgrade = TurtleUpgrades.instance().get(tag.m_128461_(key));
        if (upgrade == null) {
            return null;
        }
        String dataKey = side == TurtleSide.LEFT ? "LeftUpgradeNbt" : "RightUpgradeNbt";
        return UpgradeData.of(upgrade, NBTUtil.getCompoundOrEmpty(tag, dataKey));
    }

    @Nullable
    public ResourceLocation getOverlay(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("Overlay") ? new ResourceLocation(tag.m_128461_("Overlay")) : null;
    }

    public int getFuelLevel(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("Fuel") ? tag.m_128451_("Fuel") : 0;
    }
}

