/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class WiredModemFullBlockEntity
extends BlockEntity {
    private static final String NBT_PERIPHERAL_ENABLED = "PeripheralAccess";
    private final WiredModemPeripheral[] modems = new WiredModemPeripheral[6];
    private boolean peripheralAccessAllowed = false;
    private final WiredModemLocalPeripheral[] peripherals = new WiredModemLocalPeripheral[6];
    private boolean connectionsFormed = false;
    private boolean connectionsChanged = false;
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final ModemState modemState = new ModemState(() -> TickScheduler.schedule(this.tickToken));
    private final WiredModemElement element = new FullElement(this);
    private final WiredNode node = this.element.getNode();
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess(this, x -> this.scheduleConnectionsChanged());
    private int invalidSides = 0;

    public WiredModemFullBlockEntity(BlockEntityType<WiredModemFullBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        ComponentAccess<IPeripheral> peripheralAccess = PlatformHelper.get().createPeripheralAccess(this, this::queueRefreshPeripheral);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i] = new WiredModemLocalPeripheral(peripheralAccess);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    void neighborChanged(BlockPos neighbour) {
        if (!this.f_58857_.f_46443_ && this.peripheralAccessAllowed) {
            for (Direction facing : DirectionUtil.FACINGS) {
                if (!this.m_58899_().m_121945_(facing).equals((Object)neighbour)) continue;
                this.queueRefreshPeripheral(facing);
            }
        }
    }

    private void queueRefreshPeripheral(Direction facing) {
        if (this.invalidSides == 0) {
            TickScheduler.schedule(this.tickToken);
        }
        this.invalidSides |= 1 << facing.ordinal();
    }

    private void refreshPeripheral(Direction facing) {
        this.invalidSides &= ~(1 << facing.ordinal());
        WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
        if (this.f_58857_ != null && !this.m_58901_() && peripheral.attach(this.f_58857_, this.m_58899_(), facing)) {
            this.updateConnectedPeripherals();
        }
    }

    public InteractionResult use(Player player) {
        if (player.m_6047_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        if (this.m_58904_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Set<String> oldPeriphNames = this.getConnectedPeripheralNames();
        this.togglePeripheralAccess();
        Set<String> periphNames = this.getConnectedPeripheralNames();
        if (!Objects.equals(periphNames, oldPeriphNames)) {
            WiredModemFullBlockEntity.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_disconnected", oldPeriphNames);
            WiredModemFullBlockEntity.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_connected", periphNames);
        }
        return InteractionResult.CONSUME;
    }

    private static void sendPeripheralChanges(Player player, String kind, Collection<String> peripherals) {
        if (peripherals.isEmpty()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(peripherals);
        names.sort(Comparator.naturalOrder());
        MutableComponent base = Component.m_237113_((String)"");
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                base.m_130946_(", ");
            }
            base.m_7220_((Component)ChatHelpers.copy((String)names.get(i)));
        }
        player.m_5661_((Component)Component.m_237110_((String)kind, (Object[])new Object[]{base}), false);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.peripheralAccessAllowed = nbt.m_128471_(NBT_PERIPHERAL_ENABLED);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].read(nbt, Integer.toString(i));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].write(nbt, Integer.toString(i));
        }
        super.m_183515_(nbt);
    }

    private void updateBlockState() {
        BlockState state = this.m_58900_();
        boolean modemOn = this.modemState.isOpen();
        boolean peripheralOn = this.peripheralAccessAllowed;
        if ((Boolean)state.m_61143_((Property)WiredModemFullBlock.MODEM_ON) == modemOn && (Boolean)state.m_61143_((Property)WiredModemFullBlock.PERIPHERAL_ON) == peripheralOn) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)((BlockState)state.m_61124_((Property)WiredModemFullBlock.MODEM_ON, (Comparable)Boolean.valueOf(modemOn))).m_61124_((Property)WiredModemFullBlock.PERIPHERAL_ON, (Comparable)Boolean.valueOf(peripheralOn)));
    }

    public void m_6339_() {
        super.m_6339_();
        TickScheduler.schedule(this.tickToken);
    }

    void blockTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.invalidSides != 0) {
            for (Direction direction : DirectionUtil.FACINGS) {
                if ((this.invalidSides & 1 << direction.ordinal()) == 0) continue;
                this.refreshPeripheral(direction);
            }
        }
        if (this.modemState.pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                for (Direction facing : DirectionUtil.FACINGS) {
                    this.peripherals[facing.ordinal()].attach(this.f_58857_, this.m_58899_(), facing);
                }
                this.updateConnectedPeripherals();
            }
        }
        if (this.connectionsChanged) {
            this.connectionsChanged();
        }
    }

    private void scheduleConnectionsChanged() {
        this.connectionsChanged = true;
        TickScheduler.schedule(this.tickToken);
    }

    private void connectionsChanged() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        this.connectionsChanged = false;
        Level world = this.m_58904_();
        BlockPos current = this.m_58899_();
        for (Direction facing : DirectionUtil.FACINGS) {
            WiredElement element;
            BlockPos offset = current.m_121945_(facing);
            if (!world.m_46749_(offset) || (element = this.connectedElements.get(facing)) == null) continue;
            this.node.connectTo(element.getNode());
        }
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            boolean hasAny = false;
            for (Direction facing : DirectionUtil.FACINGS) {
                WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
                peripheral.attach(this.f_58857_, this.m_58899_(), facing);
                hasAny |= peripheral.hasPeripheral();
            }
            if (!hasAny) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.getConnectedPeripherals());
        } else {
            this.peripheralAccessAllowed = false;
            for (WiredModemLocalPeripheral peripheral : this.peripherals) {
                peripheral.detach();
            }
            this.node.updatePeripherals(Map.of());
        }
        this.updateBlockState();
    }

    private Set<String> getConnectedPeripheralNames() {
        if (!this.peripheralAccessAllowed) {
            return Set.of();
        }
        HashSet<String> peripherals = new HashSet<String>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            String name = peripheral.getConnectedName();
            if (name == null) continue;
            peripherals.add(name);
        }
        return peripherals;
    }

    private Map<String, IPeripheral> getConnectedPeripherals() {
        if (!this.peripheralAccessAllowed) {
            return Map.of();
        }
        HashMap<String, IPeripheral> peripherals = new HashMap<String, IPeripheral>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            peripheral.extendMap(peripherals);
        }
        return Collections.unmodifiableMap(peripherals);
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.getConnectedPeripherals();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    public WiredElement getElement() {
        return this.element;
    }

    @Nullable
    public WiredModemPeripheral getPeripheral(final @Nullable Direction side) {
        if (side == null) {
            return null;
        }
        WiredModemPeripheral peripheral = this.modems[side.ordinal()];
        if (peripheral != null) {
            return peripheral;
        }
        final WiredModemLocalPeripheral localPeripheral = this.peripherals[side.ordinal()];
        WiredModemPeripheral wiredModemPeripheral = new WiredModemPeripheral(this.modemState, this.element){

            @Override
            protected WiredModemLocalPeripheral getLocalPeripheral() {
                return localPeripheral;
            }

            @Override
            public Vec3 getPosition() {
                return Vec3.m_82512_((Vec3i)WiredModemFullBlockEntity.this.m_58899_().m_121945_(side));
            }

            @Override
            public Object getTarget() {
                return WiredModemFullBlockEntity.this;
            }
        };
        this.modems[side.ordinal()] = wiredModemPeripheral;
        return wiredModemPeripheral;
    }

    private static final class FullElement
    extends WiredModemElement {
        private final WiredModemFullBlockEntity entity;

        private FullElement(WiredModemFullBlockEntity entity) {
            this.entity = entity;
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.attachPeripheral(name, peripheral);
            }
        }

        @Override
        protected void detachPeripheral(String name) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.detachPeripheral(name);
            }
        }

        @Override
        public Level getLevel() {
            return this.entity.m_58904_();
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)this.entity.m_58899_());
        }
    }
}

