/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids.forge;

import com.google.common.base.Objects;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.client.SoftFluidParticleColors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class SoftFluidTankImpl
extends SoftFluidTank {
    public static SoftFluidTank create(int capacity) {
        return new SoftFluidTankImpl(capacity);
    }

    protected SoftFluidTankImpl(int capacity) {
        super(capacity);
    }

    public boolean isSameFluidAs(FluidStack fluidStack) {
        return this.isSameFluidAs(fluidStack, fluidStack.getTag());
    }

    public boolean isSameFluidAs(FluidStack fluidStack, CompoundTag com) {
        return this.fluid.isEquivalent(fluidStack.getFluid()) && Objects.equal((Object)com, (Object)this.fluid.getTag());
    }

    public boolean addVanillaFluid(FluidStack fluidStack) {
        SoftFluidStack s = SoftFluidTankImpl.convertForgeFluid(fluidStack);
        if (s == null) {
            return false;
        }
        return this.addFluid(s);
    }

    @Nullable
    public static SoftFluidStack convertForgeFluid(FluidStack fluidStack) {
        int amount = SoftFluidTankImpl.MBtoBottles(fluidStack.getAmount());
        return SoftFluidStack.fromFluid(fluidStack.getFluid(), amount, fluidStack.hasTag() ? fluidStack.getTag().m_6426_() : null);
    }

    public boolean transferToFluidTank(IFluidHandler fluidDestination, int bottles) {
        int fillableAmount;
        if (this.isEmpty() || this.getFluidCount() < bottles) {
            return false;
        }
        int milliBuckets = SoftFluidTankImpl.bottlesToMB(bottles);
        FluidStack stack = this.toEquivalentVanillaFluid(milliBuckets);
        if (!stack.isEmpty() && (fillableAmount = fluidDestination.fill(stack, IFluidHandler.FluidAction.SIMULATE)) == milliBuckets) {
            fluidDestination.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            this.fluid.shrink(bottles);
            return true;
        }
        return false;
    }

    public static int bottlesToMB(int bottles) {
        return bottles * 250;
    }

    public static int MBtoBottles(int milliBuckets) {
        return (int)((float)milliBuckets / 250.0f);
    }

    public boolean transferToFluidTank(IFluidHandler fluidDestination) {
        return this.transferToFluidTank(fluidDestination, 1);
    }

    public boolean drainFluidTank(IFluidHandler fluidSource, int bottles) {
        if (this.getSpace() < bottles) {
            return false;
        }
        int milliBuckets = SoftFluidTankImpl.bottlesToMB(bottles);
        FluidStack drainable = fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty() && drainable.getAmount() == milliBuckets) {
            boolean transfer = false;
            CompoundTag fsTag = drainable.getTag();
            if (this.fluid.isEmpty()) {
                this.setFluid(drainable);
                transfer = true;
            } else if (this.isSameFluidAs(drainable, fsTag)) {
                transfer = true;
            }
            if (transfer) {
                fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return false;
    }

    public boolean drainFluidTank(IFluidHandler fluidSource) {
        return this.drainFluidTank(fluidSource, 1);
    }

    public FluidStack toEquivalentVanillaFluid(int mb) {
        FluidStack stack = new FluidStack(this.fluid.getVanillaFluid(), mb);
        this.applyNBTtoFluidStack(stack);
        return stack;
    }

    private void applyNBTtoFluidStack(FluidStack fluidStack) {
        List<String> nbtKey = ((SoftFluid)this.fluid.getFluid().m_203334_()).getNbtKeyFromItem();
        CompoundTag tag = this.fluid.getTag();
        if (tag != null && !tag.m_128456_() && !fluidStack.isEmpty() && nbtKey != null) {
            CompoundTag newCom = new CompoundTag();
            for (String k : nbtKey) {
                Tag c;
                if (k.equals("Bottle") && Utils.getID(fluidStack.getFluid()).m_135827_().equals("immersiveengineering") || (c = tag.m_128423_(k)) == null) continue;
                newCom.m_128365_(k, c);
            }
            if (!newCom.m_128456_()) {
                fluidStack.setTag(newCom);
            }
        }
    }

    public void copy(IFluidHandler other) {
        FluidStack forgeFluid = other.getFluidInTank(0).copy();
        this.setFluid(forgeFluid);
        this.capCapacity();
    }

    public void setFluid(FluidStack fluidStack) {
        SoftFluidStack s = SoftFluidTankImpl.convertForgeFluid(fluidStack);
        if (s != null) {
            this.setFluid(s);
        }
    }

    @Override
    public int getTintColor(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) {
            return -1;
        }
        if (this.needsColorRefresh) {
            this.refreshSpecialColor(world, pos);
            this.needsColorRefresh = false;
        }
        if (this.specialColor != 0) {
            return this.specialColor;
        }
        return this.getFluidValue().getTintColor();
    }

    @Override
    public int getFlowingTint(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) {
            return this.getParticleColor(world, pos);
        }
        return this.getTintColor(world, pos);
    }

    @Override
    public int getParticleColor(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        if (this.isEmpty()) {
            return -1;
        }
        int tintColor = this.getTintColor(world, pos);
        if (tintColor == -1) {
            return SoftFluidParticleColors.getParticleColor(this.fluid.getFluid());
        }
        return tintColor;
    }

    private void refreshSpecialColor(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        CompoundTag fluidTag = this.fluid.getTag();
        if (fluidTag != null && fluidTag.m_128441_("color")) {
            this.specialColor = fluidTag.m_128451_("color");
        }
        if (this.fluid.is(BuiltInSoftFluids.POTION.get())) {
            this.specialColor = PotionNBTHelper.getColorFromNBT(fluidTag);
        } else {
            IClientFluidTypeExtensions prop;
            Fluid f = this.fluid.getVanillaFluid();
            if (f != Fluids.f_76191_ && (prop = IClientFluidTypeExtensions.of((Fluid)f)) != IClientFluidTypeExtensions.DEFAULT) {
                int w = prop.getTintColor(this.toEquivalentVanillaFluid(1));
                if (w != -1) {
                    this.specialColor = w;
                } else {
                    w = prop.getTintColor(f.m_76145_(), world, pos);
                    if (w != -1) {
                        this.specialColor = w;
                    }
                }
            }
        }
    }
}

