/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.solarheatingplate;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.antarcticgardens.newage.config.CommonConfig;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.tools.StringFormattingTool;
import org.jetbrains.annotations.Nullable;

public class SolarHeatingPlateBlockEntity
extends BlockEntity
implements HeatBlockEntity,
IHaveGoggleInformation {
    private final int energyPerSecond;
    private float last;
    public float heat = 0.0f;

    public SolarHeatingPlateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, int energyPerSecond) {
        super(type, pos, blockState);
        this.energyPerSecond = energyPerSecond;
    }

    public static SolarHeatingPlateBlockEntity createBasic(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new SolarHeatingPlateBlockEntity(type, pos, blockState, 20);
    }

    public static SolarHeatingPlateBlockEntity createAdvanced(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new SolarHeatingPlateBlockEntity(type, pos, blockState, 60);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.heat = tag.m_128457_("heat");
        this.last = tag.m_128457_("last");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("heat", this.heat);
        tag.m_128350_("last", this.last);
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.m_6596_();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.m_6596_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HeatBlockEntity.addToolTips(this, tooltip);
        Lang.translate((String)"tooltip.create_new_age.generating", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.temperature.ps", (Object[])new Object[]{StringFormattingTool.formatFloat(this.last)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 2);
        return true;
    }

    public void tick(BlockPos blockPos, Level world, BlockState blockState) {
        CommonConfig common = NewAgeConfig.getCommon();
        double generationMultiplier = (Double)common.solarPanelHeatMultiplier.get();
        int dark = 0;
        if (world.m_5776_()) {
            double d = 1.0 - (double)(world.m_46722_(1.0f) * 5.0f) / 16.0;
            double e = 1.0 - (double)(world.m_46661_(1.0f) * 5.0f) / 16.0;
            double f = 0.5 + 2.0 * Mth.m_14008_((double)Mth.m_14089_((float)(world.m_46942_(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
            dark = (int)((1.0 - f * d * e) * 11.0);
        } else {
            dark = world.m_7445_();
        }
        HeatBlockEntity.transferAround(this);
        HeatBlockEntity.handleOverheat(this);
        float light = world.m_45517_(LightLayer.SKY, blockPos.m_7494_()) - (dark *= 2);
        this.last = (float)Math.max((double)(light / 15.0f * (float)this.energyPerSecond) * generationMultiplier - Math.max(0.0, (double)this.heat - (double)(20 * this.energyPerSecond) * generationMultiplier), 0.0);
        this.addHeat(this.last);
        HeatBlockEntity.trySync(this);
    }
}

