/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import java.util.UUID;
import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.mehvahdjukaar.amendments.common.tile.SwayingBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class WallLanternBlockTile
extends SwayingBlockTile
implements IBlockHolder,
IOwnerProtected,
IExtraModelDataProvider {
    public static final ModelDataKey<BlockState> MIMIC_KEY = MimicBlockTile.MIMIC_KEY;
    private BlockState mimic = Blocks.f_50681_.m_49966_();
    protected double attachmentOffset = 0.0;
    protected boolean isRedstoneLantern = false;
    private UUID owner = null;

    public WallLanternBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.WALL_LANTERN_TILE.get(), pos, state);
    }

    public boolean isRedstoneLantern() {
        return this.isRedstoneLantern;
    }

    public double getAttachmentOffset() {
        return this.attachmentOffset;
    }

    @Override
    public Vector3f getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)WallLanternBlock.FACING)).m_253071_();
    }

    @Override
    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(MIMIC_KEY, (Object)this.getHeldBlock()).with(IS_FANCY, (Object)this.rendersFancy()).build();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setHeldBlock(Utils.readBlockState((CompoundTag)compound.m_128469_("Lantern"), (Level)this.f_58857_));
        this.isRedstoneLantern = compound.m_128471_("IsRedstone");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Lantern", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        compound.m_128379_("IsRedstone", this.isRedstoneLantern);
    }

    public BlockState getHeldBlock(int index) {
        return this.mimic;
    }

    public boolean setHeldBlock(BlockState state, int index) {
        if (state.m_61138_((Property)LanternBlock.f_153459_)) {
            state = (BlockState)state.m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false));
        }
        this.mimic = state;
        int light = ForgeHelper.getLightEmission((BlockState)state, (Level)this.f_58857_, (BlockPos)this.f_58858_);
        boolean lit = true;
        ResourceLocation res = Utils.getID((Block)this.mimic.m_60734_());
        if (res.toString().equals("charm:redstone_lantern")) {
            this.isRedstoneLantern = true;
            light = 15;
            lit = false;
        }
        if (this.f_58857_ != null && !this.mimic.m_60795_()) {
            VoxelShape shape = state.m_60808_((BlockGetter)this.f_58857_, this.f_58858_);
            if (!shape.m_83281_() && !res.m_135827_().equals("twigs")) {
                this.attachmentOffset = shape.m_83215_().f_82292_ - 0.5625;
            }
            if ((Integer)this.m_58900_().m_61143_((Property)WallLanternBlock.LIGHT_LEVEL) != light) {
                if (light == 0) {
                    lit = false;
                }
                BlockState newState = (BlockState)((BlockState)this.m_58900_().m_61124_((Property)WallLanternBlock.LIT, (Comparable)Boolean.valueOf(lit))).m_61124_((Property)WallLanternBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.max(light, 5)));
                this.m_58904_().m_7731_(this.f_58858_, newState, 20);
            }
        }
        return true;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }
}

