/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class StructureCauldronHack
extends Block
implements EntityBlock {
    private static final Supplier<StructureCauldronHack> BLOCK = RegHelper.registerBlock((ResourceLocation)Amendments.res("cauldron_hack"), StructureCauldronHack::new);
    private static final Supplier<BlockEntityType<Tile>> TILE = RegHelper.registerBlockEntityType((ResourceLocation)Amendments.res("cauldron_hack"), () -> PlatHelper.newBlockEntityType(Tile::new, (Block[])new Block[]{BLOCK.get()}));
    private static final BooleanProperty POTION = BooleanProperty.m_61465_((String)"potion");
    private static Supplier<List<Potion>> HARMFUL_POTS = Suppliers.memoize(() -> BuiltInRegistries.f_256980_.m_123024_().filter(p -> p.m_43488_().stream().noneMatch(e -> e.m_19544_().m_19486_())).toList());

    public static void register() {
    }

    public StructureCauldronHack() {
        super(BlockBehaviour.Properties.m_284310_().m_60916_(Blocks.f_50256_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POTION});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new Tile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, TILE.get(), Tile::tick);
    }

    private static class Tile
    extends BlockEntity {
        public Tile(BlockPos pos, BlockState blockState) {
            super(TILE.get(), pos, blockState);
        }

        public static <E extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, E e) {
            level.m_46597_(pos, Blocks.f_50256_.m_49966_());
            if (((Boolean)state.m_61143_((Property)POTION)).booleanValue()) {
                level.m_46597_(pos, ModRegistry.LIQUID_CAULDRON.get().m_49966_());
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                    List<Potion> list = HARMFUL_POTS.get();
                    Potion pot = list.get(level.f_46441_.m_188503_(list.size()));
                    CompoundTag tag = new CompoundTag();
                    tag.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)pot).toString());
                    if ((double)level.f_46441_.m_188501_() < 0.4) {
                        PotionNBTHelper.Type.SPLASH.applyToTag(tag);
                    }
                    te.getSoftFluidTank().setFluid(new SoftFluidStack(BuiltInSoftFluids.POTION.getHolder(), level.f_46441_.m_216332_(1, 4), tag));
                    te.m_6596_();
                }
            } else {
                level.m_46597_(pos, ModRegistry.DYE_CAULDRON.get().m_49966_());
                BlockEntity list = level.m_7702_(pos);
                if (list instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)list;
                    DyeColor dye = DyeColor.m_41053_((int)level.f_46441_.m_188503_(DyeColor.values().length));
                    SoftFluidStack fluid = DyeBottleItem.toFluidStack(dye, 3);
                    te.getSoftFluidTank().setFluid(fluid);
                    te.m_6596_();
                }
            }
        }
    }
}

