/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.HollowPillarBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;
import org.violetmoon.zeta.util.MiscUtil;

public class HollowLogBlock
extends HollowPillarBlock {
    private final boolean flammable;

    public HollowLogBlock(Block sourceLog, @Nullable ZetaModule module, boolean flammable) {
        this(Quark.ZETA.registryUtil.inherit(sourceLog, "hollow_%s"), sourceLog, module, flammable);
    }

    public HollowLogBlock(String name, Block sourceLog, @Nullable ZetaModule module, boolean flammable) {
        super(name, module, MiscUtil.copyPropertySafe((BlockBehaviour)sourceLog).m_60960_((s, g, p) -> false));
        this.flammable = flammable;
        if (module == null) {
            return;
        }
        module.zeta.renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT_MIPPED);
        this.setCreativeTab(CreativeModeTabs.f_256788_, (ItemLike)sourceLog, false);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.flammable;
    }
}

