/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.head;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public class DrinkingHatItem
extends WearableArtifactItem {
    private final Supplier<Integer> drinkingDurationMultiplier;
    private final Supplier<Integer> eatingDurationMultiplier;
    private final boolean hasSpecialTooltip;

    public DrinkingHatItem(Supplier<Integer> drinkingDurationMultiplier, Supplier<Integer> eatingDurationMultiplier, boolean hasSpecialTooltip) {
        this.drinkingDurationMultiplier = drinkingDurationMultiplier;
        this.eatingDurationMultiplier = eatingDurationMultiplier;
        this.hasSpecialTooltip = hasSpecialTooltip;
    }

    @Override
    protected boolean isCosmetic() {
        return this.drinkingDurationMultiplier.get() >= 100 && this.eatingDurationMultiplier.get() >= 100;
    }

    @Override
    protected void addTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        if (this.hasSpecialTooltip) {
            tooltip.add(this.tooltipLine("special", new Object[0]).m_130940_(ChatFormatting.ITALIC));
            this.addEffectsTooltip(stack, tooltip);
        } else {
            super.addTooltip(stack, tooltip);
        }
    }

    @Override
    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        if (this.drinkingDurationMultiplier.get() < 100) {
            tooltip.add(this.tooltipLine("drinking", new Object[0]));
        }
        if (this.eatingDurationMultiplier.get() < 100) {
            tooltip.add(this.tooltipLine("eating", new Object[0]));
        }
    }

    @Override
    protected String getTooltipItemName() {
        return "drinking_hat";
    }

    public double getDurationMultiplier(UseAnim action) {
        double multiplier = action == UseAnim.DRINK ? (double)this.drinkingDurationMultiplier.get().intValue() / 100.0 : (double)this.eatingDurationMultiplier.get().intValue() / 100.0;
        return Math.min(1.0, Math.max(0.0, multiplier));
    }

    @Override
    public SoundEvent getEquipSound() {
        return SoundEvents.f_11770_;
    }

    public static int getDrinkingHatUseDuration(LivingEntity entity, UseAnim action, int duration) {
        return Math.min(DrinkingHatItem.getDrinkingHatUseDuration(entity, action, duration, ModItems.PLASTIC_DRINKING_HAT.get()), DrinkingHatItem.getDrinkingHatUseDuration(entity, action, duration, ModItems.NOVELTY_DRINKING_HAT.get()));
    }

    private static int getDrinkingHatUseDuration(LivingEntity entity, UseAnim action, int duration, DrinkingHatItem drinkingHat) {
        if (!drinkingHat.isEquippedBy(entity) || action != UseAnim.EAT && action != UseAnim.DRINK || drinkingHat.getDurationMultiplier(action) == 1.0) {
            return duration;
        }
        return Math.max(1, (int)((double)duration * drinkingHat.getDurationMultiplier(action)));
    }
}

