/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.component.SwimEventHandler;
import artifacts.config.ModConfig;
import artifacts.entity.MimicEntity;
import artifacts.network.NetworkHandler;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModFeatures;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModLootConditions;
import artifacts.registry.ModPlacementModifierTypes;
import artifacts.registry.ModSoundEvents;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Artifacts {
    public static final String MOD_ID = "artifacts";
    public static final Logger LOGGER = LogManager.getLogger();
    public static ModConfig CONFIG;

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation id(String path, String ... args) {
        return new ResourceLocation(MOD_ID, String.format(path, args));
    }

    public static <T> ResourceKey<T> key(ResourceKey<? extends Registry<T>> registry, String path) {
        return ResourceKey.m_135785_(registry, (ResourceLocation)Artifacts.id(path));
    }

    public static void init() {
        AutoConfig.register(ModConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        CONFIG = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        NetworkHandler.register();
        ModSoundEvents.SOUND_EVENTS.register();
        ModLootConditions.LOOT_CONDITIONS.register();
        ModPlacementModifierTypes.PLACEMENT_MODIFIERS.register();
        ModItems.CREATIVE_MODE_TABS.register();
        ModItems.ITEMS.register();
        ModEntityTypes.ENTITY_TYPES.register();
        ModFeatures.FEATURES.register();
        EntityAttributeRegistry.register(ModEntityTypes.MIMIC, MimicEntity::createMobAttributes);
        LifecycleEvent.SERVER_STARTED.register(ModGameRules::onServerStarted);
        EntityEvent.ADD.register((entity, level) -> ModGameRules.onPlayerJoinLevel(entity));
        SwimEventHandler.register();
    }
}

