/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.items;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SwitchableBlockItem<T extends Property<U>, U extends Comparable<U>>
extends BlockItem {
    private T switching;
    private int max;
    private String tagName;

    public SwitchableBlockItem(Block blockIn, Item.Properties builder, T switching, String tag) {
        super(blockIn, builder);
        this.switching = switching;
        this.max = switching.m_6908_().size() - 1;
        this.tagName = tag;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.m_6144_()) {
            if (!worldIn.m_5776_()) {
                this.cycleValueTag(playerIn.m_21120_(handIn));
            }
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public BlockState getSwitchedState(BlockState state, ItemStack stack) {
        if (state != null && state.m_61138_(this.switching)) {
            state = (BlockState)state.m_61124_(this.switching, state.m_60734_().m_49966_().m_61143_(this.switching));
            for (int i = 0; i < this.getValueTag(stack); ++i) {
                state = (BlockState)state.m_61122_(this.switching);
            }
        }
        return state;
    }

    private int getValueTag(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128451_(this.tagName);
        }
        return 0;
    }

    public ItemStack cycleValueTag(ItemStack stack) {
        int currentValue;
        CompoundTag tag = stack.m_41784_();
        int n = currentValue = tag.m_128425_(this.tagName, 3) ? tag.m_128451_(this.tagName) : 0;
        if (currentValue == this.max) {
            tag.m_128473_(this.tagName);
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            } else {
                stack.m_41751_(tag);
            }
            return stack;
        }
        tag.m_128405_(this.tagName, currentValue + 1);
        stack.m_41751_(tag);
        return stack;
    }

    public static void switchHeldItem(Player player) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof SwitchableBlockItem) {
            SwitchableBlockItem switchableBlockItem = (SwitchableBlockItem)item;
            player.m_8061_(EquipmentSlot.MAINHAND, switchableBlockItem.cycleValueTag(stack));
        }
    }

    public String getTagName() {
        return this.tagName;
    }
}

