/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.core;

import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import lilypuree.decorative_blocks.blocks.BarPanelBlock;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.BonfireBlock;
import lilypuree.decorative_blocks.blocks.BrazierBlock;
import lilypuree.decorative_blocks.blocks.ChainBlock;
import lilypuree.decorative_blocks.blocks.ChandelierBlock;
import lilypuree.decorative_blocks.blocks.LatticeBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.PillarBlock;
import lilypuree.decorative_blocks.blocks.RockyDirtBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.core.DBNames;
import lilypuree.decorative_blocks.core.Registration;
import lilypuree.decorative_blocks.platform.Services;
import lilypuree.decorative_blocks.registration.BlockRegistryObject;
import lilypuree.decorative_blocks.registration.RegistrationProvider;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class DBBlocks {
    private static final RegistrationProvider<Block> BLOCK_REGISTRY = RegistrationProvider.get(Registries.f_256747_, "decorative_blocks");
    public static final BlockRegistryObject<Block> BONFIRE;
    public static final BlockRegistryObject<Block> CHANDELIER;
    public static final BlockRegistryObject<Block> BRAZIER;
    public static final BlockRegistryObject<Block> SOUL_CHANDELIER;
    public static final BlockRegistryObject<Block> SOUL_BRAZIER;
    public static final BlockRegistryObject<Block> SOUL_BONFIRE;
    public static final BlockRegistryObject<Block> BAR_PANEL;
    public static final BlockRegistryObject<Block> LATTICE;
    public static final BlockRegistryObject<Block> CHAIN;
    public static final BlockRegistryObject<Block> STONE_PILLAR;
    public static final BlockRegistryObject<Block> ROCKY_DIRT;
    public static final BlockRegistryObject<LiquidBlock> THATCH;
    public static final ImmutableMap<IWoodType, BlockRegistryObject<BeamBlock>> BEAMS;
    public static final ImmutableMap<IWoodType, BlockRegistryObject<PalisadeBlock>> PALISADES;
    public static final ImmutableMap<IWoodType, BlockRegistryObject<SupportBlock>> SUPPORTS;
    public static final ImmutableMap<IWoodType, BlockRegistryObject<SeatBlock>> SEATS;

    public static void init() {
    }

    public static Block createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        BlockBehaviour.Properties woodProperty = wood.getProperties().m_60978_(1.2f);
        BlockBehaviour.Properties palisadeProperty = wood.getProperties().m_60913_(2.0f, 4.0f);
        return switch (woodDecorativeBlockType) {
            default -> throw new IncompatibleClassChangeError();
            case WoodDecorativeBlockTypes.BEAM -> new BeamBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.SEAT -> new SeatBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.SUPPORT -> new SupportBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.PALISADE -> new PalisadeBlock(palisadeProperty, wood);
        };
    }

    private static <T extends Block> BlockRegistryObject<T> registerBlock(String name, Supplier<T> blockSupplier) {
        return BlockRegistryObject.wrap(BLOCK_REGISTRY.register(name, blockSupplier));
    }

    static {
        BlockBehaviour.Properties chainProperties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(4.3f).m_60918_(SoundType.f_56743_).m_60955_();
        BlockBehaviour.Properties thatchProperties = BlockBehaviour.Properties.m_284310_().m_278788_().m_280170_().m_60910_().m_60977_().m_222994_().m_284180_(MapColor.f_283832_).m_278166_(PushReaction.DESTROY).m_60978_(100.0f);
        BlockBehaviour.Properties bonfire = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56745_).m_60978_(0.0f).m_284180_(MapColor.f_283816_).m_278166_(PushReaction.DESTROY).m_280170_().m_60910_().m_60953_(state -> 15).m_222994_();
        BlockBehaviour.Properties soul_bonfire = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56745_).m_60978_(0.0f).m_284180_(MapColor.f_283772_).m_278166_(PushReaction.DESTROY).m_280170_().m_60910_().m_60953_(state -> 14).m_222994_();
        BlockBehaviour.Properties chandelier = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60978_(0.3f).m_278166_(PushReaction.DESTROY).m_280170_().m_60910_().m_60955_().m_60953_(state -> 15);
        BlockBehaviour.Properties soul_chandelier = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60978_(0.3f).m_278166_(PushReaction.DESTROY).m_280170_().m_60910_().m_60955_().m_60953_(state -> 11);
        BlockBehaviour.Properties brazier = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_284180_(MapColor.f_283906_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0);
        BlockBehaviour.Properties soul_brazier = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_284180_(MapColor.f_283906_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 10 : 0);
        BlockBehaviour.Properties bar_banel = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(5.0f).m_284180_(MapColor.f_283906_).m_60955_();
        BlockBehaviour.Properties lattice = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60978_(1.2f).m_284180_(MapColor.f_283825_).m_60955_();
        BlockBehaviour.Properties pillar = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60913_(1.5f, 6.5f).m_284180_(MapColor.f_283947_);
        BONFIRE = DBBlocks.registerBlock("bonfire", () -> new BonfireBlock(bonfire));
        CHANDELIER = DBBlocks.registerBlock("chandelier", () -> new ChandelierBlock(chandelier, false));
        BRAZIER = DBBlocks.registerBlock("brazier", () -> new BrazierBlock(brazier, false));
        SOUL_BONFIRE = DBBlocks.registerBlock("soul_bonfire", () -> new BonfireBlock(soul_bonfire));
        SOUL_CHANDELIER = DBBlocks.registerBlock("soul_chandelier", () -> new ChandelierBlock(soul_chandelier, true));
        SOUL_BRAZIER = DBBlocks.registerBlock("soul_brazier", () -> new BrazierBlock(soul_brazier, true));
        BAR_PANEL = DBBlocks.registerBlock("bar_panel", () -> new BarPanelBlock(bar_banel));
        LATTICE = DBBlocks.registerBlock("lattice", () -> new LatticeBlock(lattice));
        CHAIN = DBBlocks.registerBlock("chain", () -> new ChainBlock(chainProperties));
        STONE_PILLAR = DBBlocks.registerBlock("stone_pillar", () -> new PillarBlock(pillar));
        ROCKY_DIRT = DBBlocks.registerBlock("rocky_dirt", RockyDirtBlock::new);
        THATCH = DBBlocks.registerBlock("thatch", () -> Services.PLATFORM.createThatchFluidBlock(Registration.STILL_THATCH, thatchProperties));
        ImmutableMap.Builder beams = new ImmutableMap.Builder();
        ImmutableMap.Builder palisades = new ImmutableMap.Builder();
        ImmutableMap.Builder supports = new ImmutableMap.Builder();
        ImmutableMap.Builder seats = new ImmutableMap.Builder();
        for (VanillaWoodTypes woodType : VanillaWoodTypes.values()) {
            if (woodType != VanillaWoodTypes.BAMBOO) {
                beams.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.BEAM), () -> (BeamBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.BEAM)));
            }
            palisades.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.PALISADE), () -> (PalisadeBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.PALISADE)));
            supports.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.SUPPORT), () -> (SupportBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.SUPPORT)));
            seats.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.SEAT), () -> (SeatBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.SEAT)));
        }
        BEAMS = beams.build();
        PALISADES = palisades.build();
        SUPPORTS = supports.build();
        SEATS = seats.build();
    }
}

