/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BuiltinAnimation;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataDefinedCatchableMob;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DataCapturedMobInstance<T extends Entity>
extends CapturedMobInstance<T> {
    private final DataDefinedCatchableMob properties;
    @Nullable
    private final BuiltinAnimation<T> builtinAnimationInstance;

    protected DataCapturedMobInstance(T entity, float width, float height, DataDefinedCatchableMob type) {
        super(entity, width, height);
        this.properties = type;
        this.builtinAnimationInstance = BuiltinAnimation.get(entity, this.properties.builtinAnimation);
    }

    @Override
    public void containerTick(Level world, BlockPos pos, float entityScale, CompoundTag entityData) {
        Entity entity;
        ++this.entity.f_19797_;
        if (this.properties.tickMode.isValid(world) && (entity = this.entity) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_8107_();
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            this.properties.loot.ifPresent(lootParam -> lootParam.tryDropping(serverLevel, pos, this.entity));
        }
        if (this.builtinAnimationInstance != null) {
            this.builtinAnimationInstance.tick(this.entity, world, pos);
        }
    }

    @Override
    public void onContainerWaterlogged(boolean waterlogged) {
        ResourceLocation f = this.properties.forceFluidID.orElse(null);
        if (!waterlogged && f != null && f.m_135815_().equals("water")) {
            super.onContainerWaterlogged(true);
        } else {
            super.onContainerWaterlogged(waterlogged);
        }
    }
}

