/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.client.gui;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.config.Config;
import io.github.mortuusars.chalk.core.IDrawingTool;
import io.github.mortuusars.chalk.core.Mark;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.network.Packets;
import io.github.mortuusars.chalk.network.packet.ServerboundDrawMarkPacket;
import io.github.mortuusars.chalk.render.ChalkColors;
import io.github.mortuusars.chalk.utils.MarkDrawingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolSelectScreen
extends Screen {
    private static final int SYMBOL_SIZE = 48;
    private static final int SYMBOL_SPACING = 10;
    private static final float SYMBOL_BORDER_THICKNESS = 2.0f;
    private static final int DEFAULT_SYMBOL_BORDER_COLOR = -14342875;
    private static final Map<MarkSymbol, ResourceLocation> SYMBOL_TEXTURES = new HashMap<MarkSymbol, ResourceLocation>();
    private final Player player;
    private final Level level;
    private final long openTimestamp;
    private final List<MarkSymbol> unlockedSymbols;
    private final MarkDrawingContext drawingContext;
    private final InteractionHand drawingHand;
    private final int color;
    private final float r;
    private final float g;
    private final float b;
    private final int hoverBorderColor;
    private final Direction markFacing;
    private final BlockState surfaceState;
    private int centerX;
    private int centerY;
    private int buttonsWidth;
    private int buttonsStartX;
    @Nullable
    private MarkSymbol hoveredSymbol;
    private boolean mouseWasReleased;

    public SymbolSelectScreen(List<MarkSymbol> unlockedSymbols, MarkDrawingContext context) {
        super((Component)Component.m_237119_());
        int n;
        this.unlockedSymbols = unlockedSymbols;
        this.drawingContext = context;
        this.drawingHand = context.getDrawingHand();
        this.f_96541_ = Minecraft.m_91087_();
        this.player = this.f_96541_.f_91074_;
        Preconditions.checkArgument((this.player != null ? 1 : 0) != 0, (Object)"Player cannot be null.");
        this.level = this.player.m_9236_();
        this.openTimestamp = this.level.m_46467_();
        ItemStack itemInHand = this.f_96541_.f_91074_.m_21120_(this.drawingHand);
        Item item = itemInHand.m_41720_();
        if (item instanceof IDrawingTool) {
            IDrawingTool drawingTool = (IDrawingTool)item;
            n = drawingTool.getMarkColorValue(itemInHand);
        } else {
            n = ChalkColors.fromDyeColor(DyeColor.WHITE);
        }
        this.color = n;
        this.r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(this.color & 0xFF) / 255.0f;
        this.hoverBorderColor = this.color + -16777216;
        this.markFacing = this.drawingContext.getMarkFacing();
        BlockPos surfacePos = this.drawingContext.getMarkBlockPos().m_121945_(this.markFacing.m_122424_());
        this.surfaceState = this.f_96541_.f_91073_ != null ? this.f_96541_.f_91073_.m_8055_(surfacePos) : Blocks.f_50016_.m_49966_();
    }

    protected void m_7856_() {
        if (!this.drawingContext.canDraw()) {
            this.close();
            return;
        }
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.buttonsWidth = this.unlockedSymbols.size() > 0 ? 48 * this.unlockedSymbols.size() + 10 * (this.unlockedSymbols.size() - 1) : 48;
        this.buttonsStartX = this.centerX - this.buttonsWidth / 2;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        this.player.m_20124_(Pose.CROUCHING);
        if (this.player.getForcedPose() != Pose.CROUCHING) {
            this.player.setForcedPose(Pose.CROUCHING);
        }
        graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, 0x15000000, 0x35000000);
        super.m_88315_(graphics, mouseX, mouseY, pPartialTick);
        this.hoveredSymbol = null;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        for (int i = 0; i < this.unlockedSymbols.size(); ++i) {
            boolean isHovering;
            MarkSymbol symbol = this.unlockedSymbols.get(i);
            int x = this.buttonsStartX + 48 * i + 10 * i - 1;
            int y = this.centerY - 24;
            boolean bl = isHovering = mouseX >= x && mouseX <= x + 48 && mouseY >= y && mouseY <= y + 48;
            if (isHovering) {
                this.hoveredSymbol = symbol;
                this.player.m_5661_((Component)Component.m_237115_((String)symbol.getTranslationKey()), true);
            }
            this.drawSymbolButton(graphics, mouseX, mouseY, symbol, x, y, isHovering);
        }
        graphics.m_280168_().m_85849_();
    }

    private void drawSymbolButton(GuiGraphics graphics, int mouseX, int mouseY, MarkSymbol symbol, int x, int y, boolean isHovering) {
        this.renderBlockSurface(graphics, mouseX, mouseY, x, y);
        int borderColor = isHovering ? this.hoverBorderColor : -14342875;
        graphics.m_280509_((int)((float)x - 2.0f), y, x, y + 48, borderColor);
        graphics.m_280509_(x, (int)((float)y - 2.0f), x + 48, y, borderColor);
        graphics.m_280509_(x + 48, y, (int)((float)(x + 48) + 2.0f), y + 48, borderColor);
        graphics.m_280509_(x, y + 48, x + 48, (int)((float)(y + 48) + 2.0f), borderColor);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)1.0f);
        RenderSystem.enableBlend();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x + 24.0f, (float)y + 24.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(symbol.getDefaultOrientation().getRotation() + (Integer)Config.SYMBOL_ROTATION_OFFSETS.get((Object)symbol).get())));
        poseStack.m_252880_((float)(-x) - 24.0f, (float)(-y) - 24.0f, 0.0f);
        poseStack.m_252880_(0.0f, 0.0f, 100.0f);
        graphics.m_280411_(SYMBOL_TEXTURES.get((Object)symbol), x, y, 48, 48, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
        graphics.m_280024_(x, y, x + 48, y + 48, 0x8FFFFFF, 0x25000000);
    }

    private void renderBlockSurface(GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84930_();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_252880_((float)x, (float)y, 0.0f);
        int xRot = 0;
        int yRot = 0;
        if (this.markFacing == Direction.UP) {
            xRot = -90;
        } else if (this.markFacing == Direction.DOWN) {
            xRot = 90;
        }
        if (this.markFacing == Direction.EAST) {
            yRot = 270;
        } else if (this.markFacing == Direction.NORTH) {
            yRot = 180;
        } else if (this.markFacing == Direction.WEST) {
            yRot = 90;
        }
        posestack1.m_252880_(24.0f, 24.0f, 24.0f);
        posestack1.m_252781_(Axis.f_252529_.m_252977_((float)xRot - 0.1f));
        posestack1.m_252781_(Axis.f_252436_.m_252977_((float)yRot - 0.1f));
        posestack1.m_252880_(-24.0f, -24.0f, -24.0f);
        posestack1.m_252880_(0.0f, 48.0f, 0.0f);
        posestack1.m_85841_(1.0f, -1.0f, 1.0f);
        posestack1.m_85841_(48.0f, 48.0f, 48.0f);
        MultiBufferSource.BufferSource bufferSource = graphics.m_280091_();
        this.f_96541_.m_91289_().m_110912_(this.surfaceState, posestack1, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        RenderSystem.applyModelViewMatrix();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(pKeyCode, pScanCode)) {
            this.close();
            return true;
        }
        int key = pKeyCode - 48;
        if (key >= 1 && key <= Math.min(this.unlockedSymbols.size(), 9)) {
            this.tryDrawSymbol(this.unlockedSymbols.get(key - 1));
            this.close();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.mouseWasReleased && this.level.m_46467_() - this.openTimestamp < 4L) {
            this.mouseWasReleased = true;
            return true;
        }
        if (button == 0 || !this.mouseWasReleased) {
            this.tryDrawSymbol(this.hoveredSymbol);
        }
        this.close();
        return true;
    }

    private boolean tryDrawSymbol(MarkSymbol symbol) {
        if (symbol == null) {
            return false;
        }
        return this.drawSymbol(symbol);
    }

    private boolean drawSymbol(@NotNull MarkSymbol symbol) {
        Mark mark = this.createMark(symbol, this.player.m_21120_(this.drawingHand));
        if (this.drawingContext.canDraw() && (!this.drawingContext.hasExistingMark() || this.drawingContext.shouldMarkReplaceAnother(mark))) {
            Packets.sendToServer(new ServerboundDrawMarkPacket(mark.color, NbtUtils.m_129202_((BlockState)mark.createBlockState(this.player.m_21120_(this.drawingHand))), this.drawingContext.getMarkBlockPos(), this.drawingHand));
            this.player.m_6674_(this.drawingHand);
            return true;
        }
        return false;
    }

    private Mark createMark(MarkSymbol symbol, ItemStack itemInHand) {
        Item item = itemInHand.m_41720_();
        if (!(item instanceof IDrawingTool)) {
            throw new IllegalStateException("Item in hand is not IDrawingTool. [%s]".formatted(itemInHand));
        }
        IDrawingTool drawingTool = (IDrawingTool)item;
        return drawingTool.getMark(itemInHand, this.drawingContext, symbol);
    }

    public void close() {
        this.m_7379_();
    }

    public void m_7379_() {
        this.player.setForcedPose(null);
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    static {
        for (MarkSymbol symbol : MarkSymbol.getSpecialSymbols()) {
            SYMBOL_TEXTURES.put(symbol, Chalk.resource("textures/block/mark/" + symbol.m_7912_() + ".png"));
        }
    }
}

