/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.recipes.distillation;

import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillation_tower.DistillationControllerBlockEntity;
import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillery.DistilleryControllerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class AbstractDistillationRecipe
extends ProcessingRecipe<SmartInventory> {
    public static boolean match(DistilleryControllerBlockEntity controller, Recipe<?> recipe) {
        if (recipe instanceof AbstractDistillationRecipe) {
            return AbstractDistillationRecipe.apply(controller, recipe, true);
        }
        return false;
    }

    public static boolean apply(DistilleryControllerBlockEntity controller, Recipe<?> recipe) {
        return AbstractDistillationRecipe.apply(controller, recipe, false);
    }

    private static boolean apply(DistilleryControllerBlockEntity controller, Recipe<?> recipe, boolean test) {
        NonNullList fluidIngredients;
        boolean isItemlessRecipe = recipe instanceof AbstractDistillationRecipe;
        IItemHandler availableItems = (IItemHandler)controller.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluids = (IFluidHandler)controller.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = DistilleryControllerBlockEntity.getHeatLevelOf(controller.m_58904_().m_8055_(controller.m_58899_().m_6625_(1)));
        if (isItemlessRecipe && !((AbstractDistillationRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList recipeOutputFluids = new ArrayList();
        NonNullList nonNullList = fluidIngredients = isItemlessRecipe ? ((AbstractDistillationRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        if (!fluidIngredients.isEmpty()) {
            for (boolean simulate : Iterate.trueAndFalse) {
                if (!simulate && test) {
                    return true;
                }
                int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
                boolean fluidsAffected = false;
                for (int i = 0; i < fluidIngredients.size(); ++i) {
                    int drainedAmount;
                    int tank;
                    block11: {
                        FluidIngredient fluidIngredient = (FluidIngredient)fluidIngredients.get(i);
                        int amountRequired = fluidIngredient.getRequiredAmount();
                        for (tank = 0; tank < availableFluids.getTanks(); ++tank) {
                            FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                            if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                            drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                            if (!simulate) {
                                fluidStack.shrink(drainedAmount);
                                fluidsAffected = true;
                            }
                            if ((amountRequired -= drainedAmount) != 0) {
                                continue;
                            }
                            break block11;
                        }
                        return false;
                    }
                    int n = tank;
                    extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
                }
                if (fluidsAffected) {
                    ((SmartFluidTankBehaviour)controller.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                    ((SmartFluidTankBehaviour)controller.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                }
                if (!simulate) continue;
                if (recipe instanceof AbstractDistillationRecipe) {
                    AbstractDistillationRecipe ItemlessRecipe = (AbstractDistillationRecipe)recipe;
                    recipeOutputItems.addAll(ItemlessRecipe.rollResults());
                    recipeOutputFluids.addAll(ItemlessRecipe.getFluidResults());
                    continue;
                }
                RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
                recipeOutputItems.add(recipe.m_8043_(registryAccess));
            }
        }
        return true;
    }

    public static boolean match2(DistillationControllerBlockEntity controller, Recipe<?> recipe) {
        if (recipe instanceof AbstractDistillationRecipe) {
            return AbstractDistillationRecipe.apply(controller, recipe, true);
        }
        return false;
    }

    private static boolean apply2(DistillationControllerBlockEntity controller, Recipe<?> recipe, boolean test) {
        NonNullList fluidIngredients;
        boolean isItemlessRecipe = recipe instanceof AbstractDistillationRecipe;
        IItemHandler availableItems = (IItemHandler)controller.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluids = (IFluidHandler)controller.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = DistilleryControllerBlockEntity.getHeatLevelOf(controller.m_58904_().m_8055_(controller.m_58899_().m_6625_(1)));
        if (isItemlessRecipe && !((AbstractDistillationRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList recipeOutputFluids = new ArrayList();
        NonNullList nonNullList = fluidIngredients = isItemlessRecipe ? ((AbstractDistillationRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        if (!fluidIngredients.isEmpty()) {
            for (boolean simulate : Iterate.trueAndFalse) {
                if (!simulate && test) {
                    return true;
                }
                int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
                boolean fluidsAffected = false;
                for (int i = 0; i < fluidIngredients.size(); ++i) {
                    int drainedAmount;
                    int tank;
                    block11: {
                        FluidIngredient fluidIngredient = (FluidIngredient)fluidIngredients.get(i);
                        int amountRequired = fluidIngredient.getRequiredAmount();
                        for (tank = 0; tank < availableFluids.getTanks(); ++tank) {
                            FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                            if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                            drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                            if (!simulate) {
                                fluidStack.shrink(drainedAmount);
                                fluidsAffected = true;
                            }
                            if ((amountRequired -= drainedAmount) != 0) {
                                continue;
                            }
                            break block11;
                        }
                        return false;
                    }
                    int n = tank;
                    extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
                }
                if (fluidsAffected) {
                    ((SmartFluidTankBehaviour)controller.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                    ((SmartFluidTankBehaviour)controller.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                }
                if (!simulate) continue;
                if (recipe instanceof AbstractDistillationRecipe) {
                    AbstractDistillationRecipe ItemlessRecipe = (AbstractDistillationRecipe)recipe;
                    recipeOutputItems.addAll(ItemlessRecipe.rollResults());
                    recipeOutputFluids.addAll(ItemlessRecipe.getFluidResults());
                    continue;
                }
                RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
                recipeOutputItems.add(recipe.m_8043_(registryAccess));
            }
        }
        return true;
    }

    protected AbstractDistillationRecipe(IRecipeTypeInfo type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    protected int getMaxInputCount() {
        return 0;
    }

    protected int getMaxOutputCount() {
        return 2;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected int getMaxFluidOutputCount() {
        return 3;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    public boolean matches(SmartInventory inv, @Nonnull Level worldIn) {
        return false;
    }
}

