/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillery;

import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.FluidProcessingBlockEntity;
import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillation_tower.DistillationOutputBlockEntity;
import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillery.DistilleryControllerBlockEntity;
import com.drmangotea.tfmg.recipes.distillation.DistillationRecipe;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DistilleryOutputBlockEntity
extends FluidProcessingBlockEntity
implements IHaveGoggleInformation {
    protected LazyOptional<IFluidHandler> fluidCapability;
    public FluidTank tankInventory = this.createInventory();
    protected BlockPos lastKnownPos;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private static final Object DistillationRecipesKey = new Object();
    public boolean running;

    public DistilleryOutputBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.refreshCapability();
    }

    @Override
    protected <C extends Container> boolean matchItemlessRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional<DistilleryControllerBlockEntity> controller = this.getController();
        if (!controller.isPresent()) {
            return false;
        }
        return DistillationRecipe.match(controller.get(), recipe);
    }

    @Override
    protected boolean updateController() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return true;
        }
        this.recipe = this.getMatchingRecipes();
        this.startProcessing();
        this.sendData();
        return true;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        super.read(compound, clientPacket);
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        this.tankInventory.setCapacity(8000);
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
        if (this.tankInventory.getSpace() < 0) {
            this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
        super.write(compound, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this instanceof DistillationOutputBlockEntity) {
            return;
        }
        if (this.f_58857_ != null && (!this.f_58857_.f_46443_ || this.isVirtual())) {
            this.process();
            this.sendData();
        }
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
    }

    protected void process() {
        this.updateController();
        if (this.recipe == null) {
            return;
        }
        BlockEntity above1 = this.f_58857_.m_7702_(this.m_58899_().m_6630_(1));
        BlockEntity above2 = this.f_58857_.m_7702_(this.m_58899_().m_6630_(2));
        BlockEntity burner = this.f_58857_.m_7702_(this.m_58899_().m_6625_(2));
        if (!(burner instanceof BlazeBurnerBlockEntity)) {
            return;
        }
        if (((BlazeBurnerBlockEntity)burner).getHeatLevelFromBlock() == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        if (((BlazeBurnerBlockEntity)burner).getHeatLevelFromBlock() == BlazeBurnerBlock.HeatLevel.SMOULDERING) {
            return;
        }
        if (above1 != null && above2 != null) {
            Optional<DistilleryControllerBlockEntity> optionalController = this.getController();
            if (!optionalController.isPresent()) {
                return;
            }
            if (!(above1 instanceof DistilleryOutputBlockEntity) && !(above2 instanceof DistilleryOutputBlockEntity)) {
                return;
            }
            if (!(above1 instanceof DistilleryOutputBlockEntity)) {
                return;
            }
            if (!(above2 instanceof DistilleryOutputBlockEntity)) {
                return;
            }
            FluidStack fluidInRecipe1 = ((DistillationRecipe)this.recipe).getFirstFluidResult();
            FluidStack fluidInRecipe2 = ((DistillationRecipe)this.recipe).getSecondFluidResult();
            FluidStack fluidInRecipe3 = ((DistillationRecipe)this.recipe).getThirdFluidResult();
            if (fluidInRecipe1.getFluid() != this.tankInventory.getFluid().getFluid() && this.tankInventory.getFluidAmount() != 0) {
                return;
            }
            if (fluidInRecipe2.getFluid() != ((DistilleryOutputBlockEntity)above1).tankInventory.getFluid().getFluid() && ((DistilleryOutputBlockEntity)above1).tankInventory.getFluidAmount() != 0) {
                return;
            }
            if (fluidInRecipe3.getFluid() != ((DistilleryOutputBlockEntity)above2).tankInventory.getFluid().getFluid() && ((DistilleryOutputBlockEntity)above2).tankInventory.getFluidAmount() != 0) {
                return;
            }
            if (this.tankInventory.getFluidAmount() + ((DistillationRecipe)this.recipe).getFirstFluidResult().getAmount() > 8000 || ((DistilleryOutputBlockEntity)above1).tankInventory.getFluidAmount() + ((DistillationRecipe)this.recipe).getFirstFluidResult().getAmount() > 8000 || ((DistilleryOutputBlockEntity)above2).tankInventory.getFluidAmount() + ((DistillationRecipe)this.recipe).getFirstFluidResult().getAmount() > 8000) {
                return;
            }
            if (((SmartFluidTankBehaviour)this.getController().get().getTanks().get(true)).getPrimaryHandler().getFluid().getFluid() != ((FluidStack)((DistillationRecipe)this.recipe).getInputFluid().getMatchingFluidStacks().get(0)).getFluid()) {
                return;
            }
            DistilleryControllerBlockEntity controller = optionalController.get();
            if (controller.outputInventory.getStackInSlot(0).m_41613_() >= 1 || controller.outputInventory.getStackInSlot(1).m_41613_() >= 1 || controller.outputInventory.getStackInSlot(2).m_41613_() >= 1) {
                return;
            }
            if (!((SmartFluidTankBehaviour)controller.getTanks().get(true)).isEmpty()) {
                if (!this.f_58857_.f_46443_) {
                    ((SmartFluidTankBehaviour)controller.getTanks().get(true)).getPrimaryHandler().drain(((FluidIngredient)((DistillationRecipe)this.recipe).getFluidIngredients().get(0)).getRequiredAmount(), IFluidHandler.FluidAction.EXECUTE);
                    if (!((FluidStack)((DistillationRecipe)this.recipe).getFluidResults().get(0)).isEmpty()) {
                        this.tankInventory.setFluid(new FluidStack(((FluidStack)((DistillationRecipe)this.recipe).getFluidResults().get(0)).getFluid(), ((FluidStack)((DistillationRecipe)this.recipe).getFluidResults().get(0)).getAmount() + this.tankInventory.getFluidAmount()));
                    }
                    if (!((FluidStack)((DistillationRecipe)this.recipe).getFluidResults().get(1)).isEmpty()) {
                        ((DistilleryOutputBlockEntity)above1).tankInventory.setFluid(new FluidStack(((FluidStack)((DistillationRecipe)this.recipe).getFluidResults().get(1)).getFluid(), ((FluidStack)((DistillationRecipe)this.recipe).getFluidResults().get(1)).getAmount() + ((DistilleryOutputBlockEntity)above1).tankInventory.getFluidAmount()));
                    }
                    if (!((FluidStack)((DistillationRecipe)this.recipe).getFluidResults().get(2)).isEmpty()) {
                        ((DistilleryOutputBlockEntity)above2).tankInventory.setFluid(new FluidStack(((FluidStack)((DistillationRecipe)this.recipe).getFluidResults().get(2)).getFluid(), ((FluidStack)((DistillationRecipe)this.recipe).getFluidResults().get(2)).getAmount() + ((DistilleryOutputBlockEntity)above2).tankInventory.getFluidAmount()));
                    }
                    if (!((DistillationRecipe)this.recipe).getFirstItemResult().m_41619_()) {
                        controller.outputInventory.m_6836_(0, ((DistillationRecipe)this.recipe).getFirstItemResult());
                    }
                    if (!((DistillationRecipe)this.recipe).getSecondItemResult().m_41619_()) {
                        controller.outputInventory.m_6836_(1, ((DistillationRecipe)this.recipe).getSecondItemResult());
                    }
                }
                controller.notifyChangeOfContents();
            }
        }
    }

    protected DistillationRecipe getMatchingRecipes() {
        DistilleryControllerBlockEntity be = null;
        if (this.f_58857_.m_7702_(this.m_58899_().m_7495_()) instanceof DistilleryControllerBlockEntity) {
            be = (DistilleryControllerBlockEntity)this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        }
        if (be == null) {
            return null;
        }
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, this::matchStaticFilters);
        for (int i = 0; i < list.toArray().length; ++i) {
            DistillationRecipe recipe = (DistillationRecipe)((Object)list.get(i));
            for (int y = 0; y < ((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().toArray().length; ++y) {
                if (be.inputTank.getPrimaryHandler().getFluid().getFluid() != ((FluidStack)((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().get(y)).getFluid() || be.inputTank.getPrimaryHandler().getFluidAmount() < ((FluidIngredient)recipe.getFluidIngredients().get(0)).getRequiredAmount()) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    protected <C extends Container> boolean matchStaticFilters(Recipe<C> r) {
        return r instanceof DistillationRecipe;
    }

    @Override
    public void startProcessing() {
        if (this.running) {
            return;
        }
        super.startProcessing();
        this.running = true;
    }

    @Override
    public boolean continueWithPreviousRecipe() {
        return true;
    }

    @Override
    protected void onControllerRemoved() {
        if (!this.running) {
            return;
        }
        this.running = false;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return DistillationRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(8000, this::onFluidStackChanged);
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.tankInventory;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public IFluidTank getTankInventory() {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }
}

