/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillery;

import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.FluidProcessingBlockEntity;
import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillery.DistilleryControllerBlock;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class DistilleryControllerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public SmartFluidTankBehaviour inputTank;
    public SmartInventory outputInventory = new SmartInventory(9, (SyncedBlockEntity)this).forbidInsertion().withMaxStackSize(64);
    public SmartFluidTankBehaviour outputTank;
    public boolean contentsChanged = true;
    public Couple<SmartFluidTankBehaviour> tanks;
    public LazyOptional<IItemHandlerModifiable> itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.outputInventory}));
    protected LazyOptional<IFluidHandler> fluidCapability;
    public int recipeBackupCheck = 20;

    public DistilleryControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tanks = Couple.create((Object)this.inputTank, (Object)this.outputTank);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            LazyOptional outputCap = this.outputTank.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)outputCap.orElse(null), (IFluidHandler)inputCap.orElse(null)});
        });
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.outputInventory.deserializeNBT(compound.m_128469_("OutputItems"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("OutputItems", (Tag)this.outputInventory.serializeNBT());
    }

    public void remove() {
        super.remove();
        this.onEmptied();
    }

    public void onEmptied() {
        this.getOperator().ifPresent(te -> {
            te.basinRemoved = true;
        });
    }

    public void invalidate() {
        super.invalidate();
        this.itemCapability.invalidate();
        this.fluidCapability.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void notifyUpdate() {
        super.notifyUpdate();
    }

    public void lazyTick() {
        super.lazyTick();
        this.notifyUpdate();
        if (!this.f_58857_.f_46443_) {
            if (this.recipeBackupCheck-- > 0) {
                return;
            }
            this.recipeBackupCheck = 20;
        }
    }

    public void tick() {
        super.tick();
        if (!this.contentsChanged) {
            return;
        }
        this.contentsChanged = false;
        this.getOperator().ifPresent(te -> te.basinChecker.scheduleUpdate());
        for (Direction offset : Iterate.horizontalDirections) {
            BlockEntity be;
            BlockPos toUpdate = this.f_58858_.m_7494_().m_121945_(offset);
            BlockState stateToUpdate = this.f_58857_.m_8055_(toUpdate);
            if (!(stateToUpdate.m_60734_() instanceof DistilleryControllerBlock) || !((be = this.f_58857_.m_7702_(toUpdate)) instanceof DistilleryControllerBlockEntity)) continue;
            ((DistilleryControllerBlockEntity)be).contentsChanged = true;
        }
    }

    protected Optional<FluidProcessingBlockEntity> getOperator() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (te instanceof FluidProcessingBlockEntity) {
            return Optional.of((FluidProcessingBlockEntity)te);
        }
        return Optional.empty();
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public SmartInventory getOutputInventory() {
        return this.outputInventory;
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevelOf(BlockState state) {
        if (state.m_61138_((Property)BlazeBurnerBlock.HEAT_LEVEL)) {
            return (BlazeBurnerBlock.HeatLevel)state.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL);
        }
        return AllTags.AllBlockTags.PASSIVE_BOILER_HEATERS.matches(state) ? BlazeBurnerBlock.HeatLevel.SMOULDERING : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public Couple<SmartFluidTankBehaviour> getTanks() {
        return this.tanks;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }
}

