/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillation_tower;

import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillation_tower.DistillationControllerBlock;
import com.drmangotea.tfmg.blocks.tanks.SteelTankBlock;
import com.drmangotea.tfmg.blocks.tanks.SteelTankBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Arrays;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class DistillationTowerData {
    static final int SAMPLE_RATE = 1;
    private static final int waterSupplyPerLevel = 10;
    private static final float passiveEngineEfficiency = 0.0f;
    private SteelTankBlockEntity tank;
    int gatheredSupply;
    float[] supplyOverTime = new float[10];
    int ticksUntilNextSample;
    int currentIndex;
    public boolean needsHeatLevelUpdate;
    public boolean passiveHeat;
    public int activeHeat;
    public float oilSupply;
    public int attachedControllers;
    public int attachedWhistles;
    public int maxHeatForSize = 0;
    private int maxHeatForOil = 0;
    private int minValue = 0;
    private int maxValue = 0;
    public int towerLevel = this.activeHeat;
    public LerpedFloat gauge = LerpedFloat.linear();

    public void tick(SteelTankBlockEntity controller) {
        this.towerLevel = this.activeHeat;
        this.tank = controller;
        if (controller.m_58904_().f_46443_) {
            this.gauge.tickChaser();
            float current = this.gauge.getValue(1.0f);
            if (current > 1.0f && Create.RANDOM.nextFloat() < 0.5f) {
                this.gauge.setValueNoUpdate((double)(current + Math.min(-(current - 1.0f) * Create.RANDOM.nextFloat(), 0.0f)));
            }
            return;
        }
        if (this.needsHeatLevelUpdate && this.updateTemperature(controller)) {
            controller.notifyUpdate();
        }
        --this.ticksUntilNextSample;
        if (this.ticksUntilNextSample > 0) {
            return;
        }
        int capacity = controller.tankInventory.getCapacity();
        if (capacity == 0) {
            return;
        }
        this.ticksUntilNextSample = 1;
        this.supplyOverTime[this.currentIndex] = (float)this.gatheredSupply / 1.0f;
        this.oilSupply = Math.max(this.oilSupply, this.supplyOverTime[this.currentIndex]);
        this.currentIndex = (this.currentIndex + 1) % this.supplyOverTime.length;
        this.gatheredSupply = 0;
        if (this.currentIndex == 0) {
            this.oilSupply = 0.0f;
            for (float i : this.supplyOverTime) {
                this.oilSupply = Math.max(i, this.oilSupply);
            }
        }
        controller.notifyUpdate();
    }

    public int getTheoreticalHeatLevel() {
        return this.activeHeat;
    }

    public int getMaxHeatLevelForBoilerSize(int towerSize) {
        return Math.min(12, towerSize / 4);
    }

    public int getMaxHeatLevelForOilSupply() {
        return Math.min(12, Mth.m_14167_((float)this.oilSupply) / 10);
    }

    public boolean isPassive() {
        return this.passiveHeat && this.maxHeatForSize > 0 && this.maxHeatForOil > 0;
    }

    public boolean isPassive(int towerSize) {
        this.calcMinMaxForSize(towerSize);
        return this.isPassive();
    }

    public float getTowerEfficiency(int towerSize) {
        if (this.isPassive(towerSize)) {
            return 0.0f;
        }
        if (this.activeHeat == 0) {
            return 0.0f;
        }
        int actualHeat = this.getActualHeat(towerSize);
        return this.towerLevel;
    }

    public int getActualHeat(int towerSize) {
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(towerSize);
        int forWaterSupply = this.getMaxHeatLevelForOilSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize));
        return actualHeat;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, int towerSize) {
        if (!this.isActive()) {
            return false;
        }
        MutableComponent indent = Components.literal((String)"    ");
        MutableComponent indent2 = Components.literal((String)"     ");
        this.calcMinMaxForSize(towerSize);
        tooltip.add((Component)indent.m_6879_().m_7220_((Component)Lang.translateDirect((String)"distillation_tower.status", (Object[])new Object[]{this.getHeatLevelTextComponent().m_130940_(ChatFormatting.AQUA)})));
        tooltip.add((Component)indent2.m_6879_().m_7220_((Component)this.getSizeComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.m_6879_().m_7220_((Component)this.getHeatComponent(true, false, new ChatFormatting[0])));
        if (this.attachedControllers == 0) {
            return true;
        }
        int boilerLevel = Math.min(this.activeHeat, this.maxHeatForSize);
        tooltip.add(Components.immutableEmpty());
        return true;
    }

    public void calcMinMaxForSize(int towerSize) {
        this.maxHeatForSize = this.getMaxHeatLevelForBoilerSize(towerSize);
        this.maxHeatForOil = this.getMaxHeatLevelForOilSupply();
        this.minValue = Math.min(this.passiveHeat ? 1 : this.activeHeat, Math.min(this.maxHeatForOil, this.maxHeatForSize));
        this.maxValue = Math.max(this.passiveHeat ? 1 : this.activeHeat, Math.max(this.maxHeatForOil, this.maxHeatForSize));
    }

    @NotNull
    public MutableComponent getHeatLevelTextComponent() {
        int boilerLevel = Math.min(this.activeHeat, Math.min(this.maxHeatForOil, this.maxHeatForSize));
        return this.isPassive() ? Lang.translateDirect((String)"boiler.passive", (Object[])new Object[0]) : (boilerLevel == 0 ? Lang.translateDirect((String)"boiler.idle", (Object[])new Object[0]) : (boilerLevel == 18 ? Lang.translateDirect((String)"boiler.max_lvl", (Object[])new Object[0]) : Lang.translateDirect((String)"boiler.lvl", (Object[])new Object[]{String.valueOf(boilerLevel)})));
    }

    public MutableComponent getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("size", this.maxHeatForSize, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("heat", this.passiveHeat ? 1 : this.activeHeat, forGoggles, useBlocksAsBars, styles);
    }

    private MutableComponent componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        MutableComponent base;
        MutableComponent mutableComponent = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        ChatFormatting style1 = styles.length >= 1 ? styles[0] : ChatFormatting.GRAY;
        ChatFormatting style2 = styles.length >= 2 ? styles[1] : ChatFormatting.DARK_GRAY;
        return Lang.translateDirect((String)("distillation_tower." + label), (Object[])new Object[0]).m_130940_(style1).m_7220_((Component)Lang.translateDirect((String)("boiler." + label + "_dots"), (Object[])new Object[0]).m_130940_(style2)).m_7220_((Component)base);
    }

    private MutableComponent blockComponent(int level) {
        return Components.literal((String)("\u2588".repeat(this.minValue) + "\u2592".repeat(level - this.minValue) + "\u2591".repeat(this.maxValue - level)));
    }

    private MutableComponent barComponent(int level) {
        return Components.empty().m_7220_((Component)this.bars(Math.max(0, this.minValue - 1), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(this.minValue > 0 ? 1 : 0, ChatFormatting.GREEN)).m_7220_((Component)this.bars(Math.max(0, level - this.minValue), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(Math.max(0, this.maxValue - level), ChatFormatting.DARK_RED)).m_7220_((Component)this.bars(Math.max(0, Math.min(18 - this.maxValue, (this.maxValue / 5 + 1) * 5 - this.maxValue)), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Components.literal((String)Strings.repeat((char)'|', (int)level)).m_130940_(format);
    }

    public boolean evaluate(SteelTankBlockEntity controller) {
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        int prevEngines = this.attachedControllers;
        int prevWhistles = this.attachedWhistles;
        this.attachedControllers = 0;
        this.attachedWhistles = 0;
        for (int yOffset = 0; yOffset < controller.height; ++yOffset) {
            for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
                for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                    BlockPos pos = controllerPos.m_7918_(xOffset, yOffset, zOffset);
                    BlockState blockState = level.m_8055_(pos);
                    if (!SteelTankBlock.isTank(blockState)) continue;
                    for (Direction d : Iterate.directions) {
                        BlockPos attachedPos = pos.m_121945_(d);
                        BlockState attachedState = level.m_8055_(attachedPos);
                        if (!TFMGBlocks.STEEL_DISTILLATION_CONTROLLER.has(attachedState) || DistillationControllerBlock.getFacing(attachedState) != d) continue;
                        ++this.attachedControllers;
                    }
                }
            }
        }
        this.needsHeatLevelUpdate = true;
        return prevEngines != this.attachedControllers || prevWhistles != this.attachedWhistles;
    }

    public boolean updateTemperature(SteelTankBlockEntity controller) {
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        this.needsHeatLevelUpdate = false;
        boolean prevPassive = this.passiveHeat;
        int prevActive = this.activeHeat;
        this.passiveHeat = false;
        this.activeHeat = 0;
        for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
            for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                BlockState blockState;
                BlockPos pos = controllerPos.m_7918_(xOffset, -1, zOffset);
                float heat = BoilerHeaters.getActiveHeat((Level)level, (BlockPos)pos, (BlockState)(blockState = level.m_8055_(pos)));
                if (heat == 0.0f) {
                    this.passiveHeat = true;
                    continue;
                }
                if (!(heat > 0.0f)) continue;
                this.activeHeat = (int)((float)this.activeHeat + heat);
            }
        }
        this.passiveHeat &= this.activeHeat == 0;
        return prevActive != this.activeHeat || prevPassive != this.passiveHeat;
    }

    public boolean isActive() {
        return this.attachedControllers == 1;
    }

    public void clear() {
        this.oilSupply = 0.0f;
        this.activeHeat = 0;
        this.passiveHeat = false;
        this.attachedControllers = 0;
        Arrays.fill(this.supplyOverTime, 0.0f);
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("Supply", this.oilSupply);
        nbt.m_128405_("ActiveHeat", this.activeHeat);
        nbt.m_128379_("PassiveHeat", this.passiveHeat);
        nbt.m_128405_("Engines", this.attachedControllers);
        nbt.m_128405_("Whistles", this.attachedWhistles);
        nbt.m_128379_("Update", this.needsHeatLevelUpdate);
        return nbt;
    }

    public void read(CompoundTag nbt, int towerSize) {
        this.oilSupply = nbt.m_128457_("Supply");
        this.activeHeat = nbt.m_128451_("ActiveHeat");
        this.passiveHeat = nbt.m_128471_("PassiveHeat");
        this.attachedControllers = nbt.m_128451_("Engines");
        this.attachedWhistles = nbt.m_128451_("Whistles");
        this.needsHeatLevelUpdate = nbt.m_128471_("Update");
        Arrays.fill(this.supplyOverTime, (float)((int)this.oilSupply));
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(towerSize);
        int forOilSupply = this.getMaxHeatLevelForOilSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forOilSupply, forBoilerSize));
        float target = this.isPassive(towerSize) ? 0.125f : (forBoilerSize == 0 ? 0.0f : (float)actualHeat / ((float)forBoilerSize * 1.0f));
        this.gauge.chase((double)target, 0.125, LerpedFloat.Chaser.EXP);
    }

    public DistillationFluidHandler createHandler() {
        return new DistillationFluidHandler();
    }

    public class DistillationFluidHandler
    implements IFluidHandler {
        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 10000;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public static boolean isOil(Fluid fluid) {
            return FluidHelper.convertToStill((Fluid)fluid) == TFMGFluids.CRUDE_OIL.get();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isFluidValid(0, resource)) {
                return 0;
            }
            int amount = resource.getAmount();
            if (action.execute()) {
                DistillationTowerData.this.gatheredSupply += amount;
            }
            return amount;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

