/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillation_tower;

import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillation_tower.DistillationControllerBlock;
import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillation_tower.DistillationOutputBlockEntity;
import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillery.DistilleryControllerBlockEntity;
import com.drmangotea.tfmg.blocks.tanks.SteelTankBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DistillationControllerBlockEntity
extends DistilleryControllerBlockEntity
implements IHaveGoggleInformation {
    public WeakReference<SteelTankBlockEntity> source;
    public int towerLevel = 0;
    public boolean hasTank = false;
    public boolean isTallEnough = true;
    public boolean hasMainOutput = false;
    public DistillationOutputBlockEntity mainOutput;

    public DistillationControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        this.source = new WeakReference<Object>(null);
        super.tick();
        BlockEntity entityAbove = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (entityAbove instanceof DistillationOutputBlockEntity) {
            this.mainOutput = (DistillationOutputBlockEntity)entityAbove;
            this.hasMainOutput = true;
        } else {
            this.hasMainOutput = false;
        }
        SteelTankBlockEntity tank = this.getTank();
        if (tank == null) {
            this.hasTank = false;
            this.towerLevel = 0;
            return;
        }
        this.hasTank = true;
        this.towerLevel = tank.tower.towerLevel;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        Lang.translate((String)"goggles.distillation_tower.status", (Object[])new Object[0]).style(ChatFormatting.GRAY).space().forGoggles(tooltip, 1);
        if (!this.hasTank) {
            Lang.translate((String)"goggles.distillation_tower.tank_not_found", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
            return true;
        }
        if (this.towerLevel < 4) {
            Lang.translate((String)"goggles.distillation_tower.level", (Object[])new Object[]{this.towerLevel}).style(ChatFormatting.DARK_RED).forGoggles(tooltip, 1);
            return true;
        }
        if (!this.hasMainOutput) {
            Lang.translate((String)"goggles.distillation_tower.no_outputs", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip, 1);
            return true;
        }
        Lang.translate((String)"goggles.distillation_tower.level", (Object[])new Object[]{this.towerLevel}).style(ChatFormatting.GREEN).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.distillation_tower.found_outputs", (Object[])new Object[]{this.getOutputCount()}).style(ChatFormatting.GREEN).space().forGoggles(tooltip, 1);
        LazyOptional handler = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        Lang.translate((String)"goggles.fluid_in_tank", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    public int getOutputCount() {
        BlockPos checkedPos = this.m_58899_().m_6630_(3);
        int outputCount = 1;
        for (int i = 0; i < 5; ++i) {
            if (this.f_58857_.m_8055_(checkedPos).m_60713_((Block)TFMGBlocks.STEEL_DISTILLATION_OUTPUT.get()) && this.f_58857_.m_8055_(checkedPos.m_7495_()).m_60713_((Block)TFMGBlocks.INDUSTRIAL_PIPE.get())) {
                ++outputCount;
            } else {
                return outputCount;
            }
            checkedPos = checkedPos.m_6630_(2);
        }
        return outputCount;
    }

    public SteelTankBlockEntity getTank() {
        SteelTankBlockEntity tank = (SteelTankBlockEntity)((Object)this.source.get());
        if (tank == null || tank.m_58901_()) {
            Direction facing;
            BlockEntity be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_((facing = DistillationControllerBlock.getFacing(this.m_58900_())).m_122424_()))) instanceof SteelTankBlockEntity) {
                SteelTankBlockEntity tankTe;
                tank = tankTe = (SteelTankBlockEntity)be;
                this.source = new WeakReference<SteelTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }
}

