/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.engines.low_grade_fuel;

import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class LowGradeFuelEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IHaveGoggleInformation,
IWrenchable {
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected FluidTank tankInventory;
    protected FluidTank lubricationOilTank;
    protected FluidTank coolantTank;
    protected int soundTimer = 0;
    public int fuelConsumption = 0;
    public float stressTotal = 0.0f;
    public float speed = 0.0f;
    public float stressBase = 0.0f;
    public int efficiency = 1;
    public final int idealSpeed = 12;
    private int consumptionTimer = 0;
    public Fluid lubricationOil = (Fluid)TFMGFluids.LUBRICATION_OIL.get();
    public Fluid coolant = (Fluid)TFMGFluids.COOLING_FLUID.get();
    public float powerModifier = 1.0f;
    public float efficiencyModifier = 1.4f;
    int signal = 0;
    boolean signalChanged;

    public LowGradeFuelEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tankInventory = this.createInventory();
        this.lubricationOilTank = this.createUpgradeTankInventory(this.lubricationOil);
        this.coolantTank = this.createUpgradeTankInventory(this.coolant);
        this.fluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.tankInventory, this.lubricationOilTank, this.coolantTank}));
        this.setLazyTickRate(40);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!this.f_58857_.f_46443_) {
            this.calculateEfficiency();
            this.fuelConsumption = (int)(this.speed / (float)(this.efficiency / 10) / 6.0f + 1.0f);
            if (this.fuelConsumption < 1) {
                this.fuelConsumption = 0;
            }
            if (!this.tankInventory.isEmpty()) {
                if (this.consumptionTimer >= 45) {
                    if (this.signal != 0) {
                        this.tankInventory.drain(this.fuelConsumption, IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.consumptionTimer = 0;
                }
                ++this.consumptionTimer;
                return (float)(this.signal * this.signal) * 0.5f * this.powerModifier;
            }
        }
        return 0.0f;
    }

    public void calculateEfficiency() {
        if (this.signal == 0 || this.tankInventory.isEmpty()) {
            this.efficiency = 0;
            return;
        }
        this.efficiency = 100;
        if (this.signal >= 12) {
            this.efficiency = (int)((float)(100 - (this.signal - 12) * 5) / this.efficiencyModifier);
        }
        if (this.signal < 12) {
            this.efficiency = (int)((float)(100 - (12 - this.signal) * 3) / this.efficiencyModifier);
        }
        if (this.efficiency > 100) {
            this.efficiency = 100;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"goggles.engine_stats", (Object[])new Object[0]).forGoggles(tooltip);
        this.stressBase = this.calculateAddedStressCapacity();
        Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).space().forGoggles(tooltip);
        this.speed = this.getTheoreticalSpeed();
        if (this.speed != this.getGeneratedSpeed() && this.speed != 0.0f) {
            this.speed = Math.abs(this.speed);
        }
        this.stressTotal = this.stressBase * this.speed;
        Lang.number((double)this.stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.DARK_AQUA).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.engine_redstone_input", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.translate((String)"tooltip.engine_analog_strength", (Object[])new Object[]{this.signal}).style(ChatFormatting.DARK_AQUA).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.engine.efficiency", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.translate((String)"goggles.get_engine_efficiency", (Object[])new Object[]{this.efficiency}).style(ChatFormatting.DARK_AQUA).add(Lang.translate((String)"goggles.misc.percent_symbol", (Object[])new Object[0])).forGoggles(tooltip, 1);
        LazyOptional handler = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        Lang.translate((String)"goggles.fuel_container", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_AQUA)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_AQUA)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Signal", this.signal);
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
        compound.m_128365_("Coolant", (Tag)this.coolantTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("LubricationOil", (Tag)this.lubricationOilTank.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
        this.coolantTank.readFromNBT(compound.m_128469_("Coolant"));
        this.lubricationOilTank.readFromNBT(compound.m_128469_("LubricationOil"));
        this.signal = compound.m_128451_("Signal");
        super.read(compound, clientPacket);
    }

    public float getModifier() {
        return this.getModifierForSignal(this.signal);
    }

    public void neighbourChanged() {
        if (!this.m_58898_()) {
            return;
        }
        int power = this.f_58857_.m_277086_(this.f_58858_);
        if (power != this.signal) {
            this.signalChanged = true;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    public void tick() {
        super.tick();
        this.calculateUpgradeModifier();
        int random1 = Create.RANDOM.nextInt(125);
        int random2 = Create.RANDOM.nextInt(200);
        if (random1 == 69) {
            this.coolantTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
        }
        if (random2 == 69) {
            this.lubricationOilTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
        }
        ++this.soundTimer;
        if ((double)this.soundTimer >= (double)(16 - this.signal) / 0.8 + 1.0 && this.signal != 0 && this.tankInventory.getFluidAmount() != 0 && !this.overStressed && this.f_58857_.f_46443_) {
            this.makeSound();
        }
        this.updateGeneratedRotation();
        this.calculateEfficiency();
        this.stressBase = this.calculateAddedStressCapacity();
        this.speed = this.getTheoreticalSpeed();
        if (this.speed != this.getGeneratedSpeed() && this.speed != 0.0f) {
            this.stressBase *= this.getGeneratedSpeed() / this.speed;
        }
        this.speed = Math.abs(this.speed);
        this.stressTotal = this.stressBase * this.speed;
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.f_58857_.m_277086_(this.f_58858_));
        }
    }

    public void calculateUpgradeModifier() {
        float newPowerModifier = 1.0f;
        float newEfficiencyModifier = 1.4f;
        if (this.lubricationOilTank.getFluidAmount() > 0) {
            newEfficiencyModifier -= 0.1f;
        }
        if (this.coolantTank.getFluidAmount() > 0) {
            newPowerModifier += 0.3f;
            newEfficiencyModifier -= 0.3f;
        }
        this.powerModifier = newPowerModifier;
        this.efficiencyModifier = newEfficiencyModifier;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void makeSound() {
        this.soundTimer = 0;
        TFMGSoundEvents.ENGINE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.6f, 1.0f, false);
    }

    public boolean playerInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (stack.m_150930_((Item)TFMGFluids.CREOSOTE.getBucket().get()) && this.tankInventory.isEmpty()) {
            this.tankInventory.setFluid(new FluidStack((Fluid)TFMGFluids.CREOSOTE.get(), 1000));
            pPlayer.m_21008_(pHand, Items.f_42446_.m_7968_());
            return true;
        }
        return false;
    }

    protected void analogSignalChanged(int newSignal) {
        this.signal = newSignal;
    }

    protected float getModifierForSignal(int newPower) {
        if (newPower == 0) {
            return 1.0f;
        }
        return 1.0f + (float)(newPower + 1) / 16.0f;
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_(LowGradeFuelEngineBlockEntity.this.validFuel());
            }
        };
    }

    protected SmartFluidTank createUpgradeTankInventory(final Fluid validFluid) {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_(validFluid);
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
        this.fluidCapability.invalidate();
    }

    public IFluidTank getTankInventory() {
        return this.tankInventory;
    }

    public Fluid validFuel() {
        return (Fluid)TFMGFluids.CREOSOTE.get();
    }
}

