/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.engines.intake;

import com.drmangotea.tfmg.blocks.engines.intake.AirIntakeBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class AirIntakeRenderer
extends KineticBlockEntityRenderer<AirIntakeBlockEntity> {
    public AirIntakeRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(AirIntakeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        Direction direction = (Direction)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110457_());
        SuperByteBuffer frame = be.hasShaft ? CachedBufferer.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_FRAME, (BlockState)be.m_58900_(), (Direction)direction) : CachedBufferer.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_FRAME_CLOSED, (BlockState)be.m_58900_(), (Direction)direction);
        if (direction == Direction.NORTH) {
            frame.translateZ(0.001);
        }
        if (direction == Direction.SOUTH) {
            frame.translateZ(-0.001);
        }
        if (direction == Direction.WEST) {
            frame.translateX(0.001);
        }
        if (direction == Direction.EAST) {
            frame.translateX(-0.001);
        }
        if (direction == Direction.UP) {
            frame.translateY(-0.001);
        }
        if (direction == Direction.DOWN) {
            frame.translateY(0.001);
        }
        frame.renderInto(ms, vb);
        if (be.diameter == 2) {
            SuperByteBuffer chassisMedium = CachedBufferer.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_MEDIUM, (BlockState)be.m_58900_(), (Direction)direction);
            if (direction == Direction.UP) {
                chassisMedium.translateZ(1.0);
            }
            if (direction.m_122434_().m_122478_()) {
                chassisMedium.translateX(1.0);
            }
            chassisMedium.renderInto(ms, vb);
        }
        if (be.diameter == 3) {
            SuperByteBuffer chassisLarge = CachedBufferer.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_LARGE, (BlockState)be.m_58900_(), (Direction)direction);
            if (direction.m_122434_().m_122479_()) {
                chassisLarge.translateY(1.0);
                if (direction == Direction.NORTH) {
                    chassisLarge.translateX(1.0);
                }
                if (direction == Direction.SOUTH) {
                    chassisLarge.translateX(-1.0);
                }
                if (direction == Direction.EAST) {
                    chassisLarge.translateZ(1.0);
                }
                if (direction == Direction.WEST) {
                    chassisLarge.translateZ(-1.0);
                }
            } else {
                chassisLarge.translateZ(1.0);
                chassisLarge.translateX(1.0);
            }
            chassisLarge.renderInto(ms, vb);
        }
        int lightBehind = LevelRenderer.m_109541_((BlockAndTintGetter)be.m_58904_(), (BlockPos)be.m_58899_().m_121945_(direction.m_122424_()));
        int lightInFront = LevelRenderer.m_109541_((BlockAndTintGetter)be.m_58904_(), (BlockPos)be.m_58899_().m_121945_(direction));
        SuperByteBuffer shaftHalf = CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)be.m_58900_(), (Direction)direction.m_122424_());
        SuperByteBuffer fanInner = CachedBufferer.partialFacing((PartialModel)AllPartialModels.ENCASED_FAN_INNER, (BlockState)be.m_58900_(), (Direction)direction.m_122424_());
        if (be.diameter == 2) {
            fanInner = CachedBufferer.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_FAN_MEDIUM, (BlockState)be.m_58900_(), (Direction)direction.m_122424_());
        }
        if (be.diameter == 3) {
            fanInner = CachedBufferer.partialFacing((PartialModel)TFMGPartialModels.AIR_INTAKE_FAN_LARGE, (BlockState)be.m_58900_(), (Direction)direction.m_122424_());
        }
        if (direction.m_122434_().m_122479_()) {
            float x = 0.0f;
            float z = 0.0f;
            if (direction == Direction.NORTH) {
                x = 1.0f;
            }
            if (direction == Direction.SOUTH) {
                x = -1.0f;
            }
            if (direction == Direction.WEST) {
                z = -1.0f;
            }
            if (direction == Direction.EAST) {
                z = 1.0f;
            }
            if (be.diameter == 3) {
                fanInner.translate((double)x, 1.0, (double)z);
            }
            if (be.diameter == 2) {
                fanInner.translate((double)(x / 2.0f), 0.5, (double)(z / 2.0f));
            }
        } else {
            if (be.diameter == 2) {
                fanInner.translate(0.5, 0.0, 0.5);
            }
            if (be.diameter == 3) {
                fanInner.translate(1.0, 0.0, 1.0);
            }
        }
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float speed = be.maxShaftSpeed * 2.0f;
        if (speed > 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        float angle = time * speed * 3.0f / 10.0f % 360.0f;
        angle = angle / 180.0f * (float)Math.PI;
        AirIntakeRenderer.standardKineticRotationTransform((SuperByteBuffer)shaftHalf, (KineticBlockEntity)be, (int)lightBehind).renderInto(ms, vb);
        if (!be.isUsedByController) {
            AirIntakeRenderer.kineticRotationTransform((SuperByteBuffer)fanInner, (KineticBlockEntity)be, (Direction.Axis)direction.m_122434_(), (float)angle, (int)lightInFront).renderInto(ms, vb);
        }
    }
}

