/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.engines.diesel;

import com.drmangotea.tfmg.blocks.engines.diesel.DieselEngineBlock;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DieselEngineValueBox
extends ValueBoxTransform.Sided {
    protected boolean isSideActive(BlockState state, Direction direction) {
        return DieselEngineBlock.getFacing(state).m_122434_() != direction.m_122434_();
    }

    public Vec3 getLocalOffset(BlockState state) {
        boolean recessed;
        Direction side = this.getSide();
        Direction engineFacing = DieselEngineBlock.getFacing(state);
        float roll = 0.0f;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(engineFacing) != side) continue;
            roll = p.getXRotation();
        }
        if (engineFacing == Direction.UP) {
            roll += 180.0f;
        }
        float horizontalAngle = AngleHelper.horizontalAngle((Direction)engineFacing);
        float verticalAngle = AngleHelper.verticalAngle((Direction)engineFacing);
        boolean bl = recessed = roll % 180.0f == 0.0f;
        if (engineFacing.m_122434_() == Direction.Axis.Y) {
            recessed ^= ((Direction)state.m_61143_((Property)DieselEngineBlock.f_54117_)).m_122434_() == Direction.Axis.X;
        }
        Vec3 local = VecHelper.voxelSpace((double)8.0, (double)(recessed ? 13.0 : 15.0), (double)9.0);
        local = VecHelper.rotateCentered((Vec3)local, (double)roll, (Direction.Axis)Direction.Axis.Z);
        local = VecHelper.rotateCentered((Vec3)local, (double)horizontalAngle, (Direction.Axis)Direction.Axis.Y);
        local = VecHelper.rotateCentered((Vec3)local, (double)verticalAngle, (Direction.Axis)Direction.Axis.X);
        return local;
    }

    public void rotate(BlockState state, PoseStack ms) {
        Direction facing = DieselEngineBlock.getFacing(state);
        if (facing.m_122434_() == Direction.Axis.Y) {
            super.rotate(state, ms);
            return;
        }
        float roll = 0.0f;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(facing) != this.getSide()) continue;
            roll = p.getXRotation();
        }
        float yRot = AngleHelper.horizontalAngle((Direction)facing) + (float)(facing == Direction.DOWN ? 180 : 0);
        ((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)yRot)).rotateX(facing == Direction.DOWN ? -90.0 : 90.0)).rotateY((double)roll);
    }

    protected Vec3 getSouthLocation() {
        return Vec3.f_82478_;
    }
}

