/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base;

import com.drmangotea.tfmg.CreateTFMG;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.simibubi.create.infrastructure.data.CreateRegistrateTags;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraftforge.data.event.GatherDataEvent;

public class TFMGDatagen {
    public static void gatherData(GatherDataEvent event) {
        TFMGDatagen.addExtraRegistrateData();
    }

    private static void addExtraRegistrateData() {
        CreateRegistrateTags.addGenerators();
        CreateTFMG.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            TFMGDatagen.provideDefaultLang("interface", langConsumer);
            TFMGDatagen.provideDefaultLang("ponders", langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/tfmg/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }
}

