/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.utils;

import io.github.mortuusars.chalk.render.ChalkColors;
import io.github.mortuusars.chalk.utils.PositionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class ParticleUtils {
    public static void spawnParticle(Level level, ParticleOptions particleType, Vector3f position, Vector3f velocity, int count) {
        if (!level.m_5776_() || count < 1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            level.m_7106_(particleType, (double)position.x() + (double)(level.m_213780_().m_188501_() - 0.5f) * 0.3, (double)position.y() + (double)(level.m_213780_().m_188501_() - 0.5f) * 0.3, (double)position.z() + (double)(level.m_213780_().m_188501_() - 0.5f) * 0.3, (double)velocity.x(), (double)velocity.y(), (double)velocity.z());
        }
    }

    public static void spawnParticle(Level level, ParticleOptions particleType, Vector3f position, int count) {
        ParticleUtils.spawnParticle(level, particleType, position, new Vector3f(0.0f, 0.0f, 0.0f), count);
    }

    public static void spawnColorDustParticles(DyeColor color, Level level, BlockPos pos, Direction face) {
        int colorValue = ChalkColors.fromDyeColor(color);
        float R = (colorValue & 0xFF0000) >> 16;
        float G = (colorValue & 0xFF00) >> 8;
        float B = colorValue & 0xFF;
        ParticleUtils.spawnParticle(level, (ParticleOptions)new DustParticleOptions(new Vector3f(R / 255.0f, G / 255.0f, B / 255.0f), 2.0f), PositionUtils.blockCenterOffsetToFace(pos, face, 0.25f), 1);
    }
}

