/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.chalk.config.Config;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class LootTableAdditionModifier
extends LootModifier {
    public static final Supplier<Codec<LootTableAdditionModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> LootTableAdditionModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ResourceLocation.f_135803_.fieldOf("lootTable").forGetter(m -> m.lootTable)).apply((Applicative)instance, LootTableAdditionModifier::new)));
    public final ResourceLocation lootTable;

    public LootTableAdditionModifier(LootItemCondition[] conditions, ResourceLocation lootTable) {
        super(conditions);
        this.lootTable = lootTable;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)Config.GENERATE_IN_CHESTS.get()).booleanValue()) {
            return generatedLoot;
        }
        ArrayList additionalItems = new ArrayList();
        context.m_78952_().m_7654_().m_278653_().m_278676_(this.lootTable).m_79131_(context, additionalItems::add);
        generatedLoot.addAll(additionalItems);
        return generatedLoot;
    }
}

