/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.items;

import com.google.common.base.Preconditions;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.IDrawingTool;
import io.github.mortuusars.chalk.core.Mark;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.data.Lang;
import io.github.mortuusars.chalk.items.ChalkBox;
import io.github.mortuusars.chalk.items.ChalkItem;
import io.github.mortuusars.chalk.menus.ChalkBoxItemStackHandler;
import io.github.mortuusars.chalk.menus.ChalkBoxMenu;
import io.github.mortuusars.chalk.network.Packets;
import io.github.mortuusars.chalk.network.packet.ServerboundOpenChalkBoxPacket;
import io.github.mortuusars.chalk.render.ChalkColors;
import io.github.mortuusars.chalk.utils.MarkDrawingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChalkBoxItem
extends Item
implements IDrawingTool {
    public static final ResourceLocation SELECTED_PROPERTY = Chalk.resource("selected");

    public ChalkBoxItem(Item.Properties properties) {
        super(properties.setNoRepair());
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level pLevel, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        Screen style;
        int selectedChalkIndex = this.getSelectedChalkIndex(stack);
        if (selectedChalkIndex != -1) {
            Style style2;
            ItemStack selectedChalk = ChalkBox.getItemInSlot(stack, selectedChalkIndex);
            Item item = selectedChalk.m_41720_();
            if (item instanceof ChalkItem) {
                ChalkItem chalkItem = (ChalkItem)item;
                style2 = Style.f_131099_.m_178520_(ChalkColors.fromDyeColor(chalkItem.getColor()));
            } else {
                style2 = Style.f_131099_.m_131140_(ChatFormatting.WHITE);
            }
            style = style2;
            tooltipComponents.add((Component)Lang.CHALK_BOX_DRAWING_WITH_TOOLTIP.translate(new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)((MutableComponent)selectedChalk.m_41786_()).m_130948_((Style)style)));
        }
        if (Minecraft.m_91087_().f_91074_ != null && (style = Minecraft.m_91087_().f_91080_) instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen = (AbstractContainerScreen)style;
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
                return;
            }
            Slot slotUnderMouse = screen.getSlotUnderMouse();
            if (slotUnderMouse != null && slotUnderMouse.f_40218_ instanceof Inventory) {
                tooltipComponents.add((Component)Lang.CHALK_BOX_OPEN_TOOLTIP.translate(new Object[0]).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack otherStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess slotAccess) {
        if (stack.m_41720_() == this && otherStack.m_41619_() && action == ClickAction.SECONDARY && slot.f_40218_ instanceof Inventory) {
            if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
                    return false;
                }
                Packets.sendToServer(new ServerboundOpenChalkBoxPacket(slot.m_150661_()));
            }
            return true;
        }
        if (stack.m_41720_() == this && otherStack.m_41720_() instanceof ChalkItem && action == ClickAction.SECONDARY) {
            for (int i = 0; i < 8; ++i) {
                if (!ChalkBox.getItemInSlot(stack, i).m_41619_()) continue;
                ChalkBox.setSlot(stack, i, otherStack);
                player.m_5496_((SoundEvent)Chalk.SoundEvents.CHALK_BOX_CHANGE.get(), 0.9f, 0.9f + player.m_9236_().f_46441_.m_188501_() * 0.2f);
                otherStack.m_41764_(0);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack chalkBox = context.m_43722_();
        if (!chalkBox.m_150930_((Item)this)) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (context.m_43724_() == InteractionHand.OFF_HAND && (player.m_21205_().m_41720_() instanceof ChalkItem || player.m_21205_().m_150930_((Item)this))) {
            return InteractionResult.FAIL;
        }
        int selectedChalkIndex = this.getSelectedChalkIndex(chalkBox);
        if (selectedChalkIndex == -1) {
            ChalkBoxItem.openGUI(player, chalkBox);
            return InteractionResult.SUCCESS;
        }
        MarkDrawingContext drawingContext = this.createDrawingContext(context);
        if (!drawingContext.canDraw()) {
            return InteractionResult.FAIL;
        }
        ItemStack selectedChalk = ChalkBox.getItemInSlot(chalkBox, selectedChalkIndex);
        if (player.m_36341_()) {
            drawingContext.openSymbolSelectionScreen();
            return InteractionResult.CONSUME;
        }
        if (this.drawMark(drawingContext, drawingContext.createRegularMark(ChalkColors.fromDyeColor(((ChalkItem)selectedChalk.m_41720_()).getColor()), ChalkBox.getGlowLevel(chalkBox) > 0))) {
            return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack usedStack = player.m_21120_(usedHand);
        if (!usedStack.m_150930_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)usedStack);
        }
        if (player.m_36341_()) {
            this.changeSelectedChalk(usedStack);
            level.m_6263_(player, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, (SoundEvent)Chalk.SoundEvents.CHALK_BOX_CHANGE.get(), SoundSource.PLAYERS, 0.9f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        } else {
            ChalkBoxItem.openGUI(player, usedStack);
        }
        return InteractionResultHolder.m_19092_((Object)usedStack, (boolean)level.f_46443_);
    }

    public static void openGUI(Player player, ItemStack usedStack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerID, playerInventory, playerEntity) -> new ChalkBoxMenu(containerID, playerInventory, usedStack, (IItemHandler)new ChalkBoxItemStackHandler(usedStack)), usedStack.m_41786_()), buffer -> buffer.m_130055_(usedStack.m_41777_()));
            player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, (SoundEvent)Chalk.SoundEvents.CHALK_BOX_OPEN.get(), SoundSource.PLAYERS, 0.9f, 0.9f + player.m_9236_().f_46441_.m_188501_() * 0.2f);
        }
    }

    private void changeSelectedChalk(ItemStack chalkBox) {
        Preconditions.checkArgument((boolean)(chalkBox.m_41720_() instanceof ChalkBoxItem), (Object)"Item was not a Chalk Box.");
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(8);
        int chalks = 0;
        for (int slot = 0; slot < 8; ++slot) {
            ItemStack slotStack = ChalkBox.getItemInSlot(chalkBox, slot);
            stacks.add(slotStack);
            if (slotStack.m_41619_() || !(slotStack.m_41720_() instanceof ChalkItem)) continue;
            ++chalks;
        }
        if (chalks > 1) {
            int selectedChalkIndex = this.getSelectedChalkIndex(chalkBox);
            ItemStack selectedChalk = ChalkBox.getItemInSlot(chalkBox, selectedChalkIndex);
            DyeColor selectedColor = ((ChalkItem)selectedChalk.m_41720_()).getColor();
            ItemStack firstStack = (ItemStack)stacks.get(0);
            for (int i = 0; i < 8; ++i) {
                ItemStack stack = (ItemStack)stacks.get(0);
                stacks.remove(stack);
                stacks.add(stack);
                stack = (ItemStack)stacks.get(0);
                Item item = stack.m_41720_();
                if (!(item instanceof ChalkItem)) continue;
                ChalkItem chalkItem = (ChalkItem)item;
                if (!stack.equals(firstStack, false) && !chalkItem.getColor().equals((Object)selectedColor)) break;
            }
            ChalkBox.setContents(chalkBox, stacks);
        }
    }

    private int getSelectedChalkIndex(ItemStack chalkBoxStack) {
        for (int slot = 0; slot < 8; ++slot) {
            ItemStack itemInSlot = ChalkBox.getItemInSlot(chalkBoxStack, slot);
            if (!(itemInSlot.m_41720_() instanceof ChalkItem)) continue;
            return slot;
        }
        return -1;
    }

    public float getSelectedChalkColor(ItemStack stack) {
        if (stack.m_41782_()) {
            for (int i = 0; i < 8; ++i) {
                Item item = ChalkBox.getItemInSlot(stack, i).m_41720_();
                if (!(item instanceof ChalkItem)) continue;
                ChalkItem chalkItem = (ChalkItem)item;
                return chalkItem.getColor().m_41060_() + 1;
            }
        }
        return 0.0f;
    }

    @Override
    public void onMarkDrawn(Player player, InteractionHand hand, BlockPos markBlockPos, BlockState markBlockState) {
        if (player.m_7500_()) {
            return;
        }
        ItemStack chalkBox = player.m_21120_(hand);
        Preconditions.checkArgument((boolean)(chalkBox.m_41720_() instanceof ChalkBoxItem), (Object)"ChalkBox expected in player's hand.");
        int selectedChalkIndex = this.getSelectedChalkIndex(chalkBox);
        ItemStack selectedChalk = ChalkBox.getItemInSlot(chalkBox, selectedChalkIndex);
        ItemStack resultChalk = ChalkItem.damageAndDestroy(selectedChalk, player);
        ChalkBox.setSlot(chalkBox, selectedChalkIndex, resultChalk);
        if (((Boolean)markBlockState.m_61143_((Property)ChalkMarkBlock.GLOWING)).booleanValue()) {
            ChalkBox.consumeGlow(chalkBox);
        }
    }

    @Override
    public Mark getMark(ItemStack itemInHand, MarkDrawingContext drawingContext, MarkSymbol symbol) {
        DyeColor dyeColor;
        Preconditions.checkArgument((boolean)(itemInHand.m_41720_() instanceof ChalkBoxItem), (Object)"ChalkBox expected in player's hand.");
        int selectedChalkIndex = this.getSelectedChalkIndex(itemInHand);
        if (selectedChalkIndex == -1) {
            return null;
        }
        ItemStack selectedChalk = ChalkBox.getItemInSlot(itemInHand, selectedChalkIndex);
        Item item = selectedChalk.m_41720_();
        if (item instanceof ChalkItem) {
            ChalkItem chalkItem = (ChalkItem)item;
            dyeColor = chalkItem.getColor();
        } else {
            dyeColor = DyeColor.WHITE;
        }
        DyeColor color = dyeColor;
        return drawingContext.createMark(ChalkColors.fromDyeColor(color), symbol, this.getGlowing(itemInHand));
    }

    @Override
    public Optional<DyeColor> getMarkColor(ItemStack chalkBoxStack) {
        Optional<DyeColor> optional;
        Preconditions.checkArgument((boolean)(chalkBoxStack.m_41720_() instanceof ChalkBoxItem), (Object)"ChalkBox expected in player's hand.");
        int selectedChalkIndex = this.getSelectedChalkIndex(chalkBoxStack);
        if (selectedChalkIndex == -1) {
            return Optional.empty();
        }
        ItemStack selectedChalk = ChalkBox.getItemInSlot(chalkBoxStack, selectedChalkIndex);
        Item item = selectedChalk.m_41720_();
        if (item instanceof IDrawingTool) {
            IDrawingTool drawingTool = (IDrawingTool)item;
            optional = drawingTool.getMarkColor(selectedChalk);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public int getMarkColorValue(ItemStack chalkBoxStack) {
        return this.getMarkColor(chalkBoxStack).map(ChalkColors::fromDyeColor).orElse(-1);
    }

    @Override
    public boolean getGlowing(ItemStack chalkBoxStack) {
        Preconditions.checkArgument((boolean)(chalkBoxStack.m_41720_() instanceof ChalkBoxItem), (Object)"ChalkBox expected in player's hand.");
        return ChalkBox.getGlowLevel(chalkBoxStack) > 0;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }
}

