/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientVolume;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

public class BiomeEnvironment
implements Iterable<Pair<BiomeArea, AmbientVolume>> {
    private final PairList<BiomeArea, AmbientVolume> biomes = new PairList();
    private double highestRainVolume;

    public BiomeEnvironment() {
    }

    public BiomeEnvironment(AmbientEngine engine, Player player, Level level, AmbientVolume volume) {
        this.highestRainVolume = 0.0;
        if (volume.volume() > 0.0) {
            BlockPos center = BlockPos.m_274446_((Position)player.m_20299_(CreativeCoreClient.getFrameTime()));
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x2 = -engine.biomeScanCount; x2 <= engine.biomeScanCount; ++x2) {
                for (int z = -engine.biomeScanCount; z <= engine.biomeScanCount; ++z) {
                    BiomeArea area;
                    Pair before;
                    pos.m_122178_(center.m_123341_() + x2 * engine.biomeScanDistance, center.m_123342_(), center.m_123343_() + z * engine.biomeScanDistance);
                    Holder holder = level.m_204166_((BlockPos)pos);
                    float biomeConditionVolume = (float)((1.0 - center.m_123331_((Vec3i)pos) / engine.squaredBiomeDistance) * volume.conditionVolume());
                    if (level.m_46471_() && ((Biome)holder.m_203334_()).m_264600_((BlockPos)pos) == Biome.Precipitation.RAIN) {
                        this.highestRainVolume = Math.max(this.highestRainVolume, (double)biomeConditionVolume * volume.settingVolume());
                    }
                    if ((before = this.biomes.getPair((Object)(area = new BiomeArea(level, (Holder<Biome>)holder, (BlockPos)pos)))) == null) {
                        this.biomes.add((Object)area, (Object)new AmbientVolume(biomeConditionVolume, volume.settingVolume()));
                        continue;
                    }
                    if (!(((AmbientVolume)before.value).conditionVolume() < (double)biomeConditionVolume)) continue;
                    ((AmbientVolume)before.value).setConditionVolumeDirect(biomeConditionVolume);
                }
            }
            this.biomes.sort((x, y) -> ((AmbientVolume)y.value).compareTo((AmbientVolume)x.value));
        }
    }

    @Override
    public Iterator<Pair<BiomeArea, AmbientVolume>> iterator() {
        return this.biomes.iterator();
    }

    public double rainVolume() {
        return this.highestRainVolume;
    }

    public static class BiomeArea {
        public final Holder<Biome> biome;
        public final ResourceLocation location;
        public final BlockPos pos;

        public BiomeArea(Level level, Holder<Biome> biome, BlockPos pos) {
            this.biome = biome;
            this.location = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)((Biome)biome.m_203334_()));
            this.pos = pos;
        }

        public boolean checkBiome(String[] names) {
            for (String name : names) {
                if (!this.location.toString().matches(".*" + name.replace("*", ".*") + ".*")) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof BiomeArea) {
                return ((BiomeArea)object).biome.equals(this.biome);
            }
            return false;
        }

        public int hashCode() {
            return this.biome.hashCode();
        }
    }
}

