/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env;

import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientTickHandler;
import team.creative.ambientsounds.AmbientVolume;
import team.creative.ambientsounds.env.BiomeEnvironment;
import team.creative.ambientsounds.env.EntityEnvironment;
import team.creative.ambientsounds.env.TerrainEnvironment;
import team.creative.ambientsounds.mod.SereneSeasonsCompat;
import team.creative.creativecore.common.util.type.list.Pair;

public class AmbientEnvironment {
    public AmbientDimension dimension;
    public boolean muted = false;
    public boolean night;
    public double time;
    public double rainSurfaceVolume;
    public boolean raining;
    public boolean snowing;
    public boolean thundering;
    public BiomeEnvironment biome = new BiomeEnvironment();
    public TerrainEnvironment terrain = new TerrainEnvironment();
    public EntityEnvironment entity = new EntityEnvironment();
    public AmbientVolume biomeVolume = AmbientVolume.SILENT;
    public HashMap<String, AmbientVolume> biomeTypeVolumes = new HashMap();
    public double absoluteHeight;
    public double relativeHeight;
    public double relativeMinHeight;
    public double relativeMaxHeight;
    public double underwater;
    public double temperature;

    public boolean isRainAudibleAtSurface() {
        return this.rainSurfaceVolume > 0.0;
    }

    public void analyzeFast(AmbientDimension dimension, Player player, Level level, float deltaTime) {
        this.dimension = dimension;
        this.raining = level.m_46758_(player.m_20183_().m_7494_());
        this.snowing = ((Biome)level.m_204166_(player.m_20183_()).m_203334_()).m_198904_(player.m_20183_()) && level.m_46471_();
        this.thundering = level.m_46470_() && !this.snowing;
        this.absoluteHeight = player.m_20188_();
        this.relativeHeight = this.absoluteHeight - this.terrain.averageHeight;
        this.relativeMinHeight = this.absoluteHeight - (double)this.terrain.minHeight;
        this.relativeMaxHeight = this.absoluteHeight - (double)this.terrain.maxHeight;
        this.temperature = SereneSeasonsCompat.getTemperature(player);
        this.analyzeUnderwater(player, level);
        this.analyzeTime(level, deltaTime);
        this.entity.analyzeFast(dimension, player, level, deltaTime);
    }

    public void analyzeTime(Level level, float deltaTime) {
        double sunAngle = Math.toDegrees(level.m_46490_(deltaTime));
        this.night = sunAngle > 90.0 && sunAngle < 270.0;
        double fadeTime = 10.0;
        this.time = sunAngle > 90.0 - fadeTime && sunAngle < 90.0 + fadeTime ? Math.min((sunAngle - (90.0 - fadeTime)) / (fadeTime * 2.0), 1.0) : (sunAngle > 270.0 - fadeTime && sunAngle < 270.0 + fadeTime ? Math.max(1.0 - (sunAngle - (270.0 - fadeTime)) / (fadeTime * 2.0), 0.0) : (this.night ? 0.0 : 1.0));
    }

    public void analyzeUnderwater(Player player, Level level) {
        int depth = 0;
        if (player.m_204029_(FluidTags.f_13131_)) {
            BlockPos blockpos = BlockPos.m_274446_((Position)player.m_146892_());
            while (level.m_6425_(blockpos).m_205070_(FluidTags.f_13131_)) {
                ++depth;
                blockpos = blockpos.m_7494_();
            }
        }
        this.underwater = depth;
    }

    public void analyzeSlow(AmbientDimension dimension, AmbientEngine engine, Player player, Level level, float deltaTime) {
        this.terrain.analyze(engine, dimension, player, level);
        this.biome = new BiomeEnvironment(engine, player, level, this.biomeVolume);
        this.rainSurfaceVolume = this.biome.rainVolume();
    }

    public void collectLevelDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"dimension", (Object)this.dimension));
        details.add((Pair<String, Object>)new Pair((Object)"night", (Object)this.night));
        details.add((Pair<String, Object>)new Pair((Object)"rain", (Object)this.raining));
        details.add((Pair<String, Object>)new Pair((Object)"rainSurfaceVolume", (Object)this.rainSurfaceVolume));
        details.add((Pair<String, Object>)new Pair((Object)"snow", (Object)this.snowing));
        details.add((Pair<String, Object>)new Pair((Object)"storm", (Object)this.thundering));
        details.add((Pair<String, Object>)new Pair((Object)"time", (Object)this.time));
    }

    public void collectPlayerDetails(List<Pair<String, Object>> details, Player player) {
        details.add((Pair<String, Object>)new Pair((Object)"underwater", (Object)this.underwater));
        details.add((Pair<String, Object>)new Pair((Object)"temp", (Object)this.temperature));
        details.add((Pair<String, Object>)new Pair((Object)"height", (Object)("r:" + AmbientTickHandler.DECIMAL_FORMAT.format(this.relativeHeight) + ",a:" + AmbientTickHandler.DECIMAL_FORMAT.format(this.terrain.averageHeight) + " (" + AmbientTickHandler.DECIMAL_FORMAT.format(this.relativeMinHeight) + "," + AmbientTickHandler.DECIMAL_FORMAT.format(this.relativeMaxHeight) + ")")));
    }

    public void collectTerrainDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"features", (Object)this.terrain.airPocket.features.toString(AmbientTickHandler.DECIMAL_FORMAT)));
        details.add((Pair<String, Object>)new Pair((Object)"light", (Object)this.terrain.airPocket.averageLight));
        details.add((Pair<String, Object>)new Pair((Object)"sky-light", (Object)this.terrain.airPocket.averageSkyLight));
        details.add((Pair<String, Object>)new Pair((Object)"air", (Object)this.terrain.airPocket.air));
    }

    public void collectBiomeDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"b-volume", (Object)this.biomeVolume));
        for (Pair<BiomeEnvironment.BiomeArea, AmbientVolume> pair : this.biome) {
            details.add((Pair<String, Object>)new Pair((Object)((BiomeEnvironment.BiomeArea)pair.getKey()).location.toString(), pair.getValue()));
        }
    }

    public void reload() {
        this.terrain.scanner = null;
    }
}

