/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionBlockChangedPacket;
import com.simibubi.create.content.contraptions.ContraptionData;
import com.simibubi.create.content.contraptions.ContraptionDisassemblyPacket;
import com.simibubi.create.content.contraptions.ContraptionStallPacket;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsStopControllingPacket;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.sync.ContraptionSeatMappingPacket;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.mixin.accessor.ServerLevelAccessor;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.MutablePair;

public abstract class AbstractContraptionEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Boolean> STALLED = SynchedEntityData.m_135353_(AbstractContraptionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> CONTROLLED_BY = SynchedEntityData.m_135353_(AbstractContraptionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public final Map<Entity, MutableInt> collidingEntities = new IdentityHashMap<Entity, MutableInt>();
    protected Contraption contraption;
    protected boolean initialized;
    protected boolean prevPosInvalid = true;
    private boolean skipActorStop;
    public int staleTicks = 3;

    public AbstractContraptionEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void setContraption(Contraption contraption) {
        this.contraption = contraption;
        if (contraption == null) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        contraption.onEntityCreated(this);
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
        if (pType == MoverType.SHULKER) {
            return;
        }
        if (pType == MoverType.SHULKER_BOX) {
            return;
        }
        if (pType == MoverType.PISTON) {
            return;
        }
        super.m_6478_(pType, pPos);
    }

    public boolean supportsTerrainCollision() {
        return this.contraption instanceof TranslatingContraption && !(this.contraption instanceof ElevatorContraption);
    }

    protected void contraptionInitialize() {
        this.contraption.onEntityInitialize(this.m_9236_(), this);
        this.initialized = true;
    }

    public boolean collisionEnabled() {
        return true;
    }

    public void registerColliding(Entity collidingEntity) {
        this.collidingEntities.put(collidingEntity, new MutableInt());
    }

    public void addSittingPassenger(Entity passenger, int seatIndex) {
        for (Entity entity : this.m_20197_()) {
            BlockPos seatOf = this.contraption.getSeatOf(entity.m_20148_());
            if (seatOf == null || !seatOf.equals((Object)this.contraption.getSeats().get(seatIndex))) continue;
            if (entity instanceof Player) {
                return;
            }
            if (!(passenger instanceof Player)) {
                return;
            }
            entity.m_8127_();
        }
        passenger.m_7998_((Entity)this, true);
        if (passenger instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)passenger;
            ta.m_21837_(true);
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.contraption.getSeatMapping().put(passenger.m_20148_(), seatIndex);
        AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionSeatMappingPacket(this.m_19879_(), this.contraption.getSeatMapping()));
    }

    protected void m_20351_(Entity passenger) {
        Vec3 transformedVector = this.getPassengerPosition(passenger, 1.0f);
        super.m_20351_(passenger);
        if (passenger instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)passenger;
            ta.m_21837_(false);
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (transformedVector != null) {
            passenger.getPersistentData().m_128365_("ContraptionDismountLocation", (Tag)VecHelper.writeNBT(transformedVector));
        }
        this.contraption.getSeatMapping().remove(passenger.m_20148_());
        AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionSeatMappingPacket(this.m_19879_(), this.contraption.getSeatMapping(), passenger.m_19879_()));
    }

    public Vec3 m_7688_(LivingEntity entityLiving) {
        Vec3 position = super.m_7688_(entityLiving);
        CompoundTag data = entityLiving.getPersistentData();
        if (!data.m_128441_("ContraptionDismountLocation")) {
            return position;
        }
        position = VecHelper.readNBT(data.m_128437_("ContraptionDismountLocation", 6));
        data.m_128473_("ContraptionDismountLocation");
        entityLiving.m_6853_(false);
        if (!data.m_128441_("ContraptionMountLocation")) {
            return position;
        }
        Vec3 prevPosition = VecHelper.readNBT(data.m_128437_("ContraptionMountLocation", 6));
        data.m_128473_("ContraptionMountLocation");
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (!prevPosition.m_82509_((Position)position, 5000.0)) {
                AllAdvancements.LONG_TRAVEL.awardTo(player);
            }
        }
        return position;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Vec3 transformedVector = this.getPassengerPosition(passenger, 1.0f);
        if (transformedVector == null) {
            return;
        }
        callback.m_20372_(passenger, transformedVector.f_82479_, transformedVector.f_82480_ + SeatEntity.getCustomEntitySeatOffset(passenger) - 0.125, transformedVector.f_82481_);
    }

    public Vec3 getPassengerPosition(Entity passenger, float partialTicks) {
        BlockPos localPos;
        if (this.contraption == null) {
            return null;
        }
        UUID id = passenger.m_20148_();
        if (passenger instanceof OrientedContraptionEntity && (localPos = this.contraption.getBearingPosOf(id)) != null) {
            return this.toGlobalVector(VecHelper.getCenterOf((Vec3i)localPos), partialTicks).m_82549_(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_)).m_82492_(0.5, 1.0, 0.5);
        }
        AABB bb = passenger.m_20191_();
        double ySize = bb.m_82376_();
        BlockPos seat = this.contraption.getSeatOf(id);
        if (seat == null) {
            return null;
        }
        Vec3 transformedVector = this.toGlobalVector(Vec3.m_82528_((Vec3i)seat).m_82520_(0.5, passenger.m_6049_() + ySize - (double)0.15f, 0.5), partialTicks).m_82549_(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_)).m_82492_(0.5, ySize, 0.5);
        return transformedVector;
    }

    protected boolean m_7310_(Entity p_184219_1_) {
        if (p_184219_1_ instanceof OrientedContraptionEntity) {
            return true;
        }
        return this.contraption.getSeatMapping().size() < this.contraption.getSeats().size();
    }

    public Component getContraptionName() {
        return this.m_7755_();
    }

    public Optional<UUID> getControllingPlayer() {
        return (Optional)this.f_19804_.m_135370_(CONTROLLED_BY);
    }

    public void setControllingPlayer(@Nullable UUID playerId) {
        this.f_19804_.m_135381_(CONTROLLED_BY, Optional.ofNullable(playerId));
    }

    public boolean startControlling(BlockPos controlsLocalPos, Player player) {
        return false;
    }

    public boolean control(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player) {
        return true;
    }

    public void stopControlling(BlockPos controlsLocalPos) {
        this.getControllingPlayer().map(arg_0 -> ((Level)this.m_9236_()).m_46003_(arg_0)).map(p -> p instanceof ServerPlayer ? (ServerPlayer)p : null).ifPresent(p -> AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> p), (Object)new ControlsStopControllingPacket()));
        this.setControllingPlayer(null);
    }

    public boolean handlePlayerInteraction(Player player, BlockPos localPos, Direction side, InteractionHand interactionHand) {
        int indexOfSeat = this.contraption.getSeats().indexOf(localPos);
        if (indexOfSeat == -1 || AllItems.WRENCH.isIn(player.m_21120_(interactionHand))) {
            if (this.contraption.interactors.containsKey(localPos)) {
                return this.contraption.interactors.get(localPos).handlePlayerInteraction(player, interactionHand, localPos, this);
            }
            return this.contraption.storage.handlePlayerStorageInteraction(this.contraption, player, localPos);
        }
        if (player.m_20159_()) {
            return false;
        }
        Entity toDismount = null;
        for (Map.Entry<UUID, Integer> entry : this.contraption.getSeatMapping().entrySet()) {
            if (entry.getValue() != indexOfSeat) continue;
            for (Entity entity : this.m_20197_()) {
                if (!entry.getKey().equals(entity.m_20148_())) continue;
                if (entity instanceof Player) {
                    return false;
                }
                toDismount = entity;
            }
        }
        if (toDismount != null && !this.m_9236_().f_46443_) {
            Vec3 transformedVector = this.getPassengerPosition(toDismount, 1.0f);
            toDismount.m_8127_();
            if (transformedVector != null) {
                toDismount.m_6021_(transformedVector.f_82479_, transformedVector.f_82480_, transformedVector.f_82481_);
            }
        }
        if (this.m_9236_().f_46443_) {
            return true;
        }
        this.addSittingPassenger((Entity)SeatBlock.getLeashed(this.m_9236_(), player).or((Object)player), indexOfSeat);
        return true;
    }

    public Vec3 toGlobalVector(Vec3 localVec, float partialTicks) {
        return this.toGlobalVector(localVec, partialTicks, false);
    }

    public Vec3 toGlobalVector(Vec3 localVec, float partialTicks, boolean prevAnchor) {
        Vec3 anchor = prevAnchor ? this.getPrevAnchorVec() : this.getAnchorVec();
        Vec3 rotationOffset = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_);
        localVec = localVec.m_82546_(rotationOffset);
        localVec = this.applyRotation(localVec, partialTicks);
        localVec = localVec.m_82549_(rotationOffset).m_82549_(anchor);
        return localVec;
    }

    public Vec3 toLocalVector(Vec3 localVec, float partialTicks) {
        return this.toLocalVector(localVec, partialTicks, false);
    }

    public Vec3 toLocalVector(Vec3 globalVec, float partialTicks, boolean prevAnchor) {
        Vec3 anchor = prevAnchor ? this.getPrevAnchorVec() : this.getAnchorVec();
        Vec3 rotationOffset = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_);
        globalVec = globalVec.m_82546_(anchor).m_82546_(rotationOffset);
        globalVec = this.reverseRotation(globalVec, partialTicks);
        globalVec = globalVec.m_82549_(rotationOffset);
        return globalVec;
    }

    public void m_8119_() {
        Object object;
        if (this.contraption == null) {
            this.m_146870_();
            return;
        }
        this.collidingEntities.entrySet().removeIf(e -> ((MutableInt)e.getValue()).incrementAndGet() > 3);
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.prevPosInvalid = false;
        if (!this.initialized) {
            this.contraptionInitialize();
        }
        this.contraption.tickStorage(this);
        this.tickContraption();
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                if (!this.contraption.deferInvalidate) {
                    return;
                }
                this.contraption.deferInvalidate = false;
                ContraptionRenderDispatcher.invalidate(this.contraption);
            });
        }
        if (!((object = this.m_9236_()) instanceof ServerLevelAccessor)) {
            return;
        }
        ServerLevelAccessor sl = (ServerLevelAccessor)object;
        for (Entity entity : this.m_20197_()) {
            if (entity instanceof Player || entity.m_142389_() || sl.create$getEntityTickList().m_156914_(entity)) continue;
            this.m_7332_(entity);
        }
    }

    public void alignPassenger(Entity passenger) {
        Vec3 motion = this.getContactPointMotion(passenger.m_146892_());
        if (Mth.m_14082_((double)motion.m_82553_(), (double)0.0)) {
            return;
        }
        if (passenger instanceof ArmorStand) {
            return;
        }
        if (!(passenger instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)passenger;
        float prevAngle = living.m_146908_();
        float angle = AngleHelper.deg(-Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_));
        angle = AngleHelper.angleLerp(0.4f, prevAngle, angle);
        if (this.m_9236_().f_46443_) {
            living.m_6453_(0.0, 0.0, 0.0, 0.0f, 0.0f, 0, false);
            living.m_6541_(0.0f, 0);
            living.m_146922_(angle);
            living.m_146926_(0.0f);
            living.f_20883_ = angle;
            living.f_20885_ = angle;
        } else {
            living.m_146922_(angle);
        }
    }

    public void setBlock(BlockPos localPos, StructureTemplate.StructureBlockInfo newInfo) {
        this.contraption.blocks.put(localPos, newInfo);
        AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionBlockChangedPacket(this.m_19879_(), localPos, newInfo.f_74676_()));
    }

    protected abstract void tickContraption();

    public abstract Vec3 applyRotation(Vec3 var1, float var2);

    public abstract Vec3 reverseRotation(Vec3 var1, float var2);

    public void tickActors() {
        boolean stalledPreviously = this.contraption.stalled;
        if (!this.m_9236_().f_46443_) {
            this.contraption.stalled = false;
        }
        this.skipActorStop = true;
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.contraption.getActors()) {
            MovementContext context = (MovementContext)pair.right;
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)pair.left;
            MovementBehaviour actor = AllMovementBehaviours.getBehaviour(blockInfo.f_74676_());
            if (actor == null) continue;
            Vec3 oldMotion = context.motion;
            Vec3 actorPosition = this.toGlobalVector(VecHelper.getCenterOf((Vec3i)blockInfo.f_74675_()).m_82549_(actor.getActiveAreaOffset(context)), 1.0f);
            BlockPos gridPosition = BlockPos.m_274446_((Position)actorPosition);
            boolean newPosVisited = !context.stall && this.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition);
            context.rotation = v -> this.applyRotation((Vec3)v, 1.0f);
            context.position = actorPosition;
            if (!this.isActorActive(context, actor) && !actor.mustTickWhileDisabled()) continue;
            if (newPosVisited && !context.stall) {
                actor.visitNewPosition(context, gridPosition);
                if (!this.m_6084_()) break;
                context.firstMovement = false;
            }
            if (!oldMotion.equals((Object)context.motion)) {
                actor.onSpeedChanged(context, oldMotion, context.motion);
                if (!this.m_6084_()) break;
            }
            actor.tick(context);
            if (!this.m_6084_()) break;
            this.contraption.stalled |= context.stall;
        }
        if (!this.m_6084_()) {
            this.contraption.stop(this.m_9236_());
            return;
        }
        this.skipActorStop = false;
        for (Entity entity : this.m_20197_()) {
            if (!(entity instanceof OrientedContraptionEntity) || !this.contraption.stabilizedSubContraptions.containsKey(entity.m_20148_())) continue;
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (orientedCE.contraption == null || !orientedCE.contraption.stalled) continue;
            this.contraption.stalled = true;
            break;
        }
        if (!this.m_9236_().f_46443_) {
            if (!stalledPreviously && this.contraption.stalled) {
                this.onContraptionStalled();
            }
            this.f_19804_.m_135381_(STALLED, (Object)this.contraption.stalled);
            return;
        }
        this.contraption.stalled = this.isStalled();
    }

    public void refreshPSIs() {
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.contraption.getActors()) {
            MovementContext context = (MovementContext)pair.right;
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)pair.left;
            MovementBehaviour actor = AllMovementBehaviours.getBehaviour(blockInfo.f_74676_());
            if (!(actor instanceof PortableStorageInterfaceMovement) || !this.isActorActive(context, actor) || context.position == null) continue;
            actor.visitNewPosition(context, BlockPos.m_274446_((Position)context.position));
        }
    }

    protected boolean isActorActive(MovementContext context, MovementBehaviour actor) {
        return actor.isActive(context);
    }

    protected void onContraptionStalled() {
        AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionStallPacket(this.m_19879_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getStalledAngle()));
    }

    protected boolean shouldActorTrigger(MovementContext context, StructureTemplate.StructureBlockInfo blockInfo, MovementBehaviour actor, Vec3 actorPosition, BlockPos gridPosition) {
        CarriageContraptionEntity cce;
        AbstractContraptionEntity abstractContraptionEntity;
        Vec3 previousPosition = context.position;
        if (previousPosition == null) {
            return false;
        }
        context.motion = actorPosition.m_82546_(previousPosition);
        if (!this.m_9236_().m_5776_() && (abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity && (cce = (CarriageContraptionEntity)abstractContraptionEntity).getCarriage() != null) {
            Train train = cce.getCarriage().train;
            double actualSpeed = train.speedBeforeStall != null ? train.speedBeforeStall : train.speed;
            context.motion = context.motion.m_82541_().m_82490_(Math.abs(actualSpeed));
        }
        Vec3 relativeMotion = context.motion;
        context.relativeMotion = relativeMotion = this.reverseRotation(relativeMotion, 1.0f);
        return !BlockPos.m_274446_((Position)previousPosition).equals((Object)gridPosition) || (context.relativeMotion.m_82553_() > 0.0 || context.contraption instanceof CarriageContraption) && context.firstMovement;
    }

    public void move(double x, double y, double z) {
        this.m_6034_(this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z);
    }

    public Vec3 getAnchorVec() {
        return this.m_20182_();
    }

    public Vec3 getPrevAnchorVec() {
        return this.getPrevPositionVec();
    }

    public float getYawOffset() {
        return 0.0f;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        if (this.contraption == null) {
            return;
        }
        AABB cbox = this.contraption.bounds;
        if (cbox == null) {
            return;
        }
        Vec3 actualVec = this.getAnchorVec();
        this.m_20011_(cbox.m_82383_(actualVec));
    }

    public static float yawFromVector(Vec3 vec) {
        return (float)((4.71238898038469 + Math.atan2(vec.f_82481_, vec.f_82479_)) / Math.PI * 180.0);
    }

    public static float pitchFromVector(Vec3 vec) {
        return (float)(Math.acos(vec.f_82480_) / Math.PI * 180.0);
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.m_20699_(1.0f, 1.0f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STALLED, (Object)false);
        this.f_19804_.m_135372_(CONTROLLED_BY, Optional.empty());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.writeAdditional(compound, true);
        if (ContraptionData.isTooLargeForSync(compound)) {
            String info = this.getContraption().getType().id + " @" + this.m_20182_() + " (" + this.m_20149_() + ")";
            Create.LOGGER.warn("Could not send Contraption Spawn Data (Packet too big): " + info);
            compound = null;
        }
        buffer.m_130079_(compound);
    }

    protected final void m_7380_(CompoundTag compound) {
        this.writeAdditional(compound, false);
    }

    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        if (this.contraption != null) {
            compound.m_128365_("Contraption", (Tag)this.contraption.writeNBT(spawnPacket));
        }
        compound.m_128379_("Stalled", this.isStalled());
        compound.m_128379_("Initialized", this.initialized);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag nbt = additionalData.m_130261_();
        if (nbt != null) {
            this.readAdditional(nbt, true);
        }
    }

    protected final void m_7378_(CompoundTag compound) {
        this.readAdditional(compound, false);
    }

    protected void readAdditional(CompoundTag compound, boolean spawnData) {
        if (compound.m_128456_()) {
            return;
        }
        this.initialized = compound.m_128471_("Initialized");
        this.contraption = Contraption.fromNBT(this.m_9236_(), compound.m_128469_("Contraption"), spawnData);
        this.contraption.entity = this;
        this.f_19804_.m_135381_(STALLED, (Object)compound.m_128471_("Stalled"));
    }

    public void disassemble() {
        if (!this.m_6084_()) {
            return;
        }
        if (this.contraption == null) {
            return;
        }
        StructureTransform transform = this.makeStructureTransform();
        this.contraption.stop(this.m_9236_());
        AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionDisassemblyPacket(this.m_19879_(), transform));
        this.contraption.addBlocksToWorld(this.m_9236_(), transform);
        this.contraption.addPassengersToWorld(this.m_9236_(), transform, this.m_20197_());
        for (Entity entity : this.m_20197_()) {
            UUID id;
            if (!(entity instanceof OrientedContraptionEntity) || !this.contraption.stabilizedSubContraptions.containsKey(id = entity.m_20148_())) continue;
            BlockPos transformed = transform.apply(this.contraption.stabilizedSubContraptions.get(id).getConnectedPos());
            entity.m_6034_((double)transformed.m_123341_(), (double)transformed.m_123342_(), (double)transformed.m_123343_());
            ((AbstractContraptionEntity)entity).disassemble();
        }
        this.skipActorStop = true;
        this.m_146870_();
        this.m_20153_();
        this.moveCollidedEntitiesOnDisassembly(transform);
        AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.m_9236_(), (Vec3i)this.m_20183_());
    }

    private void moveCollidedEntitiesOnDisassembly(StructureTransform transform) {
        for (Entity entity : this.collidingEntities.keySet()) {
            Vec3 localVec = this.toLocalVector(entity.m_20182_(), 0.0f);
            Vec3 transformed = transform.apply(localVec);
            if (this.m_9236_().f_46443_) {
                entity.m_6034_(transformed.f_82479_, transformed.f_82480_ + 0.0625, transformed.f_82481_);
                continue;
            }
            entity.m_6021_(transformed.f_82479_, transformed.f_82480_ + 0.0625, transformed.f_82481_);
        }
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (!(this.m_9236_().f_46443_ || this.m_213877_() || this.contraption == null || this.skipActorStop)) {
            this.contraption.stop(this.m_9236_());
        }
        if (this.contraption != null) {
            this.contraption.onEntityRemoved(this);
        }
        super.m_142687_(p_146834_);
    }

    protected abstract StructureTransform makeStructureTransform();

    public void m_6074_() {
        this.m_20153_();
        super.m_6074_();
    }

    protected void m_6088_() {
        this.m_20153_();
        super.m_6088_();
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    protected void m_5841_() {
    }

    public Contraption getContraption() {
        return this.contraption;
    }

    public boolean isStalled() {
        return (Boolean)this.f_19804_.m_135370_(STALLED);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void handleStallPacket(ContraptionStallPacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ce = (AbstractContraptionEntity)entity;
            ce.handleStallInformation(packet.x, packet.y, packet.z, packet.angle);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static void handleBlockChangedPacket(ContraptionBlockChangedPacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ce = (AbstractContraptionEntity)entity;
            ce.handleBlockChange(packet.localPos, packet.newState);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static void handleDisassemblyPacket(ContraptionDisassemblyPacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ce = (AbstractContraptionEntity)entity;
            ce.moveCollidedEntitiesOnDisassembly(packet.transform);
        }
    }

    protected abstract float getStalledAngle();

    protected abstract void handleStallInformation(double var1, double var3, double var5, float var7);

    @OnlyIn(value=Dist.CLIENT)
    protected void handleBlockChange(BlockPos localPos, BlockState newState) {
        if (this.contraption == null || !this.contraption.blocks.containsKey(localPos)) {
            return;
        }
        StructureTemplate.StructureBlockInfo info = this.contraption.blocks.get(localPos);
        this.contraption.blocks.put(localPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
        if (info.f_74676_() != newState && !(newState.m_60734_() instanceof SlidingDoorBlock)) {
            this.contraption.deferInvalidate = true;
        }
        this.contraption.invalidateColliders();
    }

    public CompoundTag m_20240_(CompoundTag nbt) {
        Vec3 vec = this.m_20182_();
        List passengers = this.m_20197_();
        for (Entity entity : passengers) {
            entity.f_146795_ = Entity.RemovalReason.UNLOADED_TO_CHUNK;
            Vec3 prevVec = entity.m_20182_();
            entity.m_20343_(vec.f_82479_, prevVec.f_82480_, vec.f_82481_);
            entity.f_146795_ = null;
        }
        CompoundTag tag = super.m_20240_(nbt);
        return tag;
    }

    public void m_20256_(Vec3 motionIn) {
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void setContraptionMotion(Vec3 vec) {
        super.m_20256_(vec);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public Vec3 getPrevPositionVec() {
        return this.prevPosInvalid ? this.m_20182_() : new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
    }

    public abstract ContraptionRotationState getRotationState();

    public Vec3 getContactPointMotion(Vec3 globalContactPoint) {
        if (this.prevPosInvalid) {
            return Vec3.f_82478_;
        }
        Vec3 contactPoint = this.toGlobalVector(this.toLocalVector(globalContactPoint, 0.0f, true), 1.0f, true);
        Vec3 contraptionLocalMovement = contactPoint.m_82546_(globalContactPoint);
        Vec3 contraptionAnchorMovement = this.m_20182_().m_82546_(this.getPrevPositionVec());
        return contraptionLocalMovement.m_82549_(contraptionAnchorMovement);
    }

    public boolean m_7337_(Entity e) {
        if (e instanceof Player && e.m_5833_()) {
            return false;
        }
        if (e.f_19794_) {
            return false;
        }
        if (e instanceof HangingEntity) {
            return false;
        }
        if (e instanceof AbstractMinecart) {
            return !(this.contraption instanceof MountedContraption);
        }
        if (e instanceof SuperGlueEntity) {
            return false;
        }
        if (e instanceof SeatEntity) {
            return false;
        }
        if (e instanceof Projectile) {
            return false;
        }
        if (e.m_20202_() != null) {
            return false;
        }
        for (Entity riding = this.m_20202_(); riding != null; riding = riding.m_20202_()) {
            if (riding != e) continue;
            return false;
        }
        return e.m_7752_() == PushReaction.NORMAL;
    }

    public boolean m_146898_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void applyLocalTransforms(PoseStack var1, float var2);

    protected boolean m_20073_() {
        return false;
    }

    public void m_20254_(int p_70015_1_) {
    }

    public boolean isReadyForRender() {
        return this.initialized;
    }

    public boolean isAliveOrStale() {
        return this.m_6084_() || this.m_9236_().m_5776_() ? this.staleTicks > 0 : false;
    }

    public static class ContraptionRotationState {
        public static final ContraptionRotationState NONE = new ContraptionRotationState();
        float xRotation = 0.0f;
        float yRotation = 0.0f;
        float zRotation = 0.0f;
        float secondYRotation = 0.0f;
        Matrix3d matrix;

        public Matrix3d asMatrix() {
            if (this.matrix != null) {
                return this.matrix;
            }
            this.matrix = new Matrix3d().asIdentity();
            if (this.xRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asXRotation(AngleHelper.rad(-this.xRotation)));
            }
            if (this.yRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asYRotation(AngleHelper.rad(-this.yRotation)));
            }
            if (this.zRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asZRotation(AngleHelper.rad(-this.zRotation)));
            }
            return this.matrix;
        }

        public boolean hasVerticalRotation() {
            return this.xRotation != 0.0f || this.zRotation != 0.0f;
        }

        public float getYawOffset() {
            return this.secondYRotation;
        }
    }
}

