/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.motors.extension;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.newage.content.motors.MotorBlock;
import org.antarcticgardens.newage.content.motors.MotorBlockEntity;
import org.antarcticgardens.newage.content.motors.extension.MotorExtensionBlockEntity;
import org.antarcticgardens.newage.content.motors.extension.variants.IMotorExtensionVariant;
import org.antarcticgardens.newage.content.reactor.reactorfuelacceptor.ReactorFuelAcceptorBlock;
import org.jetbrains.annotations.Nullable;

public class MotorExtensionBlock
extends Block
implements IBE<MotorExtensionBlockEntity>,
IWrenchable {
    protected static final VoxelShape Y_AXIS_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private final BlockEntityEntry<MotorExtensionBlockEntity> entry;
    private final IMotorExtensionVariant variant;

    public MotorExtensionBlock(BlockBehaviour.Properties properties, BlockEntityEntry<MotorExtensionBlockEntity> entry, IMotorExtensionVariant variant) {
        super(properties);
        this.entry = entry;
        this.variant = variant;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ReactorFuelAcceptorBlock.FACING});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.create_new_age.motor_extension").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Lang.translate((String)"tooltip.create_new_age.stress_limit_multiplier", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltip.add((Component)Lang.text((String)" ").add(Lang.number((double)((int)(this.variant.getMultiplier() * 100.0f))).text("%").style(ChatFormatting.AQUA)).component());
        tooltip.add((Component)Lang.translate((String)"tooltip.create_new_age.additional_capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltip.add((Component)Lang.text((String)" ").add(Lang.number((double)this.variant.getExtraCapacity()).text("\u26a1").style(ChatFormatting.AQUA)).component());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_().m_122424_();
        BlockPos pos = context.m_8083_();
        if (context.m_43723_() != null && context.m_43723_().m_6047_()) {
            direction = direction.m_122424_();
        } else if (!(context.m_43725_().m_8055_(pos.m_121945_(direction)).m_60734_() instanceof MotorBlock)) {
            for (Direction d : Direction.values()) {
                if (!(context.m_43725_().m_8055_(pos.m_121945_(d)).m_60734_() instanceof MotorBlock)) continue;
                direction = d;
                break;
            }
        }
        BlockState blockState = (BlockState)super.m_5573_(context).m_61124_((Property)ReactorFuelAcceptorBlock.FACING, (Comparable)direction);
        return blockState;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            if (player != null && !player.m_7500_()) {
                Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
            }
            state.m_222967_((ServerLevel)world, pos, ItemStack.f_41583_, true);
            world.m_46961_(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity entity;
        if (state.m_155947_() && (entity = context.m_43725_().m_7702_(context.m_8083_())) instanceof MotorBlockEntity) {
            MotorBlockEntity en = (MotorBlockEntity)entity;
            en.needsPower = !en.needsPower;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
        return switch (((Direction)arg.m_61143_((Property)ReactorFuelAcceptorBlock.FACING)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> X_AXIS_AABB;
            case Direction.Axis.Z -> Z_AXIS_AABB;
            case Direction.Axis.Y -> Y_AXIS_AABB;
        };
    }

    public Class<MotorExtensionBlockEntity> getBlockEntityClass() {
        return MotorExtensionBlockEntity.class;
    }

    public BlockEntityType<? extends MotorExtensionBlockEntity> getBlockEntityType() {
        return (BlockEntityType)this.entry.get();
    }
}

