/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.monorail;

import com.google.common.collect.ImmutableMap;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackVoxelShapes;
import com.railwayteam.railways.mixin.client.AccessorTrackBlockOutline;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CustomTrackBlockOutline {
    public static final VoxelShape MONORAIL_LONG_CROSS = Shapes.m_83110_((VoxelShape)MonorailTrackVoxelShapes.longOrthogonalZ(), (VoxelShape)MonorailTrackVoxelShapes.longOrthogonalX());
    public static final VoxelShape MONORAIL_LONG_ORTHO = MonorailTrackVoxelShapes.longOrthogonalZ();
    public static final VoxelShape MONORAIL_LONG_ORTHO_OFFSET = MonorailTrackVoxelShapes.longOrthogonalZOffset();
    public static final VoxelShape NARROW_LONG_ORTHO = Block.m_49796_((double)-7.0, (double)0.0, (double)-3.3, (double)23.0, (double)4.0, (double)19.3);
    public static final VoxelShape NARROW_LONG_ORTHO_2 = Block.m_49796_((double)-3.3, (double)0.0, (double)-7.0, (double)19.3, (double)4.0, (double)23.0);
    public static final VoxelShape NARROW_LONG_ORTHO_OFFSET = Block.m_49796_((double)-7.0, (double)0.0, (double)0.0, (double)23.0, (double)4.0, (double)24.0);
    public static final VoxelShape NARROW_LONG_CROSS = Shapes.m_83110_((VoxelShape)NARROW_LONG_ORTHO, (VoxelShape)NARROW_LONG_ORTHO_2);
    public static final Map<VoxelShape, VoxelShape> TRACK_TO_MONORAIL = Map.of(AllShapes.TRACK_ORTHO.get(Direction.EAST), CRShapes.MONORAIL_TRACK_ORTHO.get(Direction.EAST), AllShapes.TRACK_ORTHO.get(Direction.SOUTH), CRShapes.MONORAIL_TRACK_ORTHO.get(Direction.SOUTH), AllShapes.TRACK_CROSS, CRShapes.MONORAIL_TRACK_CROSS);
    public static final Map<VoxelShape, VoxelShape> TRACK_TO_NARROW = ImmutableMap.builder().putAll(Map.of(AllShapes.TRACK_ORTHO.get(Direction.EAST), CRShapes.NARROW_TRACK_ORTHO.get(Direction.EAST), AllShapes.TRACK_ORTHO.get(Direction.SOUTH), CRShapes.NARROW_TRACK_ORTHO.get(Direction.SOUTH), AllShapes.TRACK_CROSS, CRShapes.NARROW_TRACK_CROSS, AllShapes.TRACK_DIAG.get(Direction.EAST), CRShapes.NARROW_TRACK_DIAG.get(Direction.EAST), AllShapes.TRACK_DIAG.get(Direction.SOUTH), CRShapes.NARROW_TRACK_DIAG.get(Direction.SOUTH))).putAll(Map.of(AllShapes.TRACK_CROSS_DIAG, CRShapes.NARROW_TRACK_CROSS_DIAG, AccessorTrackBlockOutline.getLONG_ORTHO_OFFSET(), NARROW_LONG_ORTHO_OFFSET, AccessorTrackBlockOutline.getLONG_ORTHO(), NARROW_LONG_ORTHO, AccessorTrackBlockOutline.getLONG_CROSS(), NARROW_LONG_CROSS)).build();

    public static VoxelShape convert(Object o, TrackMaterial material) {
        if (o instanceof VoxelShape) {
            VoxelShape shape = (VoxelShape)o;
            return CustomTrackBlockOutline.convert(shape, material);
        }
        throw new IllegalArgumentException("object is not a VoxelShape");
    }

    public static VoxelShape convert(VoxelShape trackShape, TrackMaterial material) {
        if (material == CRTrackMaterials.MONORAIL) {
            return TRACK_TO_MONORAIL.getOrDefault(trackShape, trackShape);
        }
        if (material.trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE) {
            return TRACK_TO_NARROW.getOrDefault(trackShape, trackShape);
        }
        return trackShape;
    }

    public static boolean skipCustomRendering() {
        if (Utils.isDevEnv()) {
            // empty if block
        }
        return false;
    }
}

