/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.forge;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.BuilderTransformers;
import com.railwayteam.railways.content.conductor.vent.VentBlock;
import com.railwayteam.railways.content.conductor.whistle.ConductorWhistleFlagBlock;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.content.custom_bogeys.CRBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.invisible.InvisibleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.monobogey.AbstractMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.monobogey.InvisibleMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.monobogey.MonoBogeyBlock;
import com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionBlock;
import com.railwayteam.railways.content.semaphore.SemaphoreBlock;
import com.railwayteam.railways.content.smokestack.DieselSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.OilburnerSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.SmokeStackBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class BuilderTransformersImpl {
    public static <B extends MonoBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> monobogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/monorail/top" + ((Boolean)s.m_61143_((Property)AbstractMonoBogeyBlock.UPSIDE_DOWN) != false ? "_upside_down" : ""))))).loot((p, l) -> p.m_246125_((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    public static <B extends InvisibleBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> invisibleBogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/invisible/top")))).loot((p, l) -> p.m_246125_((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    public static <B extends SmokeStackBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> smokestack(boolean rotates, ResourceLocation modelLoc) {
        return a -> a.blockstate((c, p) -> {
            if (rotates) {
                p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(modelLoc)).rotationY(state.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.X ? 90 : 0).build());
            } else {
                p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(modelLoc)).build());
            }
        });
    }

    public static <B extends SemaphoreBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> semaphore() {
        return a -> a.blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/semaphore/block" + ((Boolean)state.m_61143_((Property)SemaphoreBlock.FULL) != false ? "_full" : "") + ((Boolean)state.m_61143_((Property)SemaphoreBlock.FLIPPED) != false ? "_flipped" : "") + ((Boolean)state.m_61143_((Property)SemaphoreBlock.UPSIDE_DOWN) != false ? "_down" : "")))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build()));
    }

    public static <B extends TrackCouplerBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> trackCoupler() {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{((TrackCouplerBlockEntity.AllowedOperationMode)((Object)((Object)((Object)((Object)state.m_61143_(TrackCouplerBlock.MODE)))))).m_7912_()})).build(), new Property[]{TrackCouplerBlock.POWERED}));
    }

    public static <B extends TrackSwitchBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> trackSwitch(boolean andesite) {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/track_switch_" + (andesite ? "andesite" : "brass") + "/block"))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build(), new Property[]{TrackSwitchBlock.LOCKED}));
    }

    public static <B extends ConductorWhistleFlagBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> conductorWhistleFlag() {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"pole"})).build()));
    }

    public static <B extends DieselSmokeStackBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> dieselSmokeStack() {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/smokestack/block_diesel_case"))).build()));
    }

    public static <B extends VentBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> conductorVent() {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile((Boolean)state.m_61143_((Property)VentBlock.CONDUCTOR_VISIBLE) != false ? Railways.asResource("block/copycat_vent_visible") : new ResourceLocation("block/air"))).build()));
    }

    public static <B extends InvisibleMonoBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> invisibleMonoBogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(p -> p.m_60955_()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/invisible_monorail/top" + ((Boolean)s.m_61143_((Property)AbstractMonoBogeyBlock.UPSIDE_DOWN) != false ? "_upside_down" : ""))))).loot((p, l) -> p.m_246125_((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    public static NonNullBiConsumer<DataGenContext<Block, SmokeStackBlock>, RegistrateBlockstateProvider> defaultSmokeStack(ResourceLocation modelLoc, boolean rotates) {
        return (c, p) -> {
            if (rotates) {
                p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(modelLoc)).rotationY(state.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.X ? 90 : 0).build());
            } else {
                p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(modelLoc)).build());
            }
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, SmokeStackBlock>, RegistrateBlockstateProvider> oilburnerSmokeStack() {
        return (c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/smokestack/block_oilburner" + ((Boolean)state.m_61143_((Property)OilburnerSmokeStackBlock.ENCASED) != false ? "_encased" : "")))).build());
    }

    public static <B extends CasingCollisionBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> casingCollision() {
        return a -> a.blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().withExistingParent(c.getName(), p.mcLoc("block/air"))));
    }

    public static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> standardBogey() {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.sharedBogey())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/top"))));
    }

    public static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> wideBogey() {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.sharedBogey())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/wide/top"))));
    }

    public static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> narrowBogey() {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.sharedBogey())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/narrow/top"))));
    }
}

