/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemUtil {
    private static int MAX_OVERVIEW = 3;

    public static ContentOverview getContentOverview(IItemHandler inventory) {
        HashMap<Item, Integer> retMap = new HashMap<Item, Integer>(MAX_OVERVIEW);
        int isMore = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            Integer existing = retMap.get(item);
            if (existing != null) {
                retMap.put(item, existing + stack.m_41613_());
                continue;
            }
            if (retMap.size() >= MAX_OVERVIEW) {
                ++isMore;
                continue;
            }
            retMap.put(item, stack.m_41613_());
        }
        return new ContentOverview(retMap, isMore);
    }

    public static class ContentOverview {
        private final Map<Item, Integer> contents;
        private int isMore = 0;

        private ContentOverview(Map<Item, Integer> contents, int isMore) {
            this.contents = contents;
            this.isMore = isMore;
        }

        public int isMore() {
            return this.isMore;
        }

        public Map<Item, Integer> contents() {
            return this.contents;
        }
    }
}

