/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import java.util.List;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class HellHoundTalent
extends TalentInstance {
    private final int SEARCH_RANGE = 3;
    private int tickUntilSearch = 0;
    private int fireResistTickLeft = 60;
    private int fireResistHealCooldown = 0;

    public HellHoundTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public InteractionResultHolder<Float> calculateFallDistance(AbstractDog dogIn, float distance) {
        if (this.level() >= 5 && dogIn.m_20077_()) {
            return InteractionResultHolder.m_19090_((Object)Float.valueOf(0.0f));
        }
        return super.calculateFallDistance(dogIn, distance);
    }

    @Override
    public InteractionResultHolder<Integer> setFire(AbstractDog dogIn, int second) {
        return InteractionResultHolder.m_19090_((Object)Mth.m_14143_((float)((float)second * this.getFireDecreasePercentage())));
    }

    private float getFireDecreasePercentage() {
        if (this.level() <= 0 || this.level() >= 5) {
            return 1.0f;
        }
        switch (this.level()) {
            default: {
                return 1.0f;
            }
            case 1: {
                return 0.9f;
            }
            case 2: {
                return 0.8f;
            }
            case 3: {
                return 0.5f;
            }
            case 4: 
        }
        return 0.25f;
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        if (this.level() >= 5) {
            props.setFireImmune();
        }
    }

    @Override
    public InteractionResult isInvulnerableTo(AbstractDog dogIn, DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return this.level() >= 5 ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void doInitialAttackEffects(AbstractDog dogIn, Entity entity) {
        if (this.level() >= 5) {
            entity.m_20254_(15);
        } else if (this.level() >= 4) {
            entity.m_20254_(4);
        }
    }

    @Override
    public InteractionResult canResistPushFromFluidType(FluidType type) {
        if (type != ForgeMod.LAVA_TYPE.get()) {
            return InteractionResult.PASS;
        }
        if (this.level() >= 5) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<Float> gettingAttackedFrom(AbstractDog dog, DamageSource source, float damage) {
        if (!source.m_269533_(DamageTypeTags.f_268745_)) {
            return InteractionResultHolder.m_19098_((Object)Float.valueOf(damage));
        }
        int resistValue = this.getResistValue(source);
        this.fireResistHealCooldown = 80;
        this.fireResistTickLeft = Math.min(this.fireResistTickLeft, resistValue);
        if (this.fireResistTickLeft > 0) {
            return InteractionResultHolder.m_19100_((Object)Float.valueOf(0.0f));
        }
        this.fireResistTickLeft = resistValue;
        return InteractionResultHolder.m_19098_((Object)Float.valueOf(this.getFireDamageReduced(source, damage)));
    }

    private float getFireDamageReduced(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268546_)) {
            if (this.level() >= 4) {
                return 1.0f;
            }
            if (this.level() >= 3) {
                return 2.0f;
            }
            return Math.max(0.0f, 1.0f - (float)this.level() * 0.25f) * amount;
        }
        return 1.0f;
    }

    private int getMaxAccumulate() {
        if (this.level() <= 2) {
            return this.level() + 1;
        }
        if (this.level() <= 3) {
            return this.level() + 3;
        }
        return this.level() + 10;
    }

    private int getResistValue(DamageSource source) {
        if (this.level() >= 4) {
            return this.getMaxAccumulate() * 20;
        }
        if (source.m_276093_(DamageTypes.f_268546_)) {
            return this.getMaxAccumulate() * 10;
        }
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return this.getMaxAccumulate() * 15;
        }
        return this.getMaxAccumulate() * 20;
    }

    @Override
    public InteractionResult shouldNotAfraidOfFire(AbstractDog dog) {
        if (this.level() < 3) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult stillIdleOrSitWhenHurt(AbstractDog dog, DamageSource source, float amount) {
        if (this.level() >= 4 && source.m_269533_(DamageTypeTags.f_268745_)) {
            return InteractionResult.SUCCESS;
        }
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void tick(AbstractDog d) {
        if (d.m_9236_().f_46443_) {
            return;
        }
        if (this.level() < 5) {
            this.updateResistValues();
            return;
        }
        if (!(d instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)d;
        this.floatHellhound(dog);
        if (dog != null && dog.isShakingLava() && (double)dog.getTimeDogIsShaking() > 0.8 && --this.tickUntilSearch <= 0) {
            this.tickUntilSearch = 10;
            this.fireSpreadToEnermies(dog);
        }
    }

    private void updateResistValues() {
        if (this.fireResistHealCooldown > 0) {
            --this.fireResistHealCooldown;
        }
        if (this.fireResistHealCooldown <= 0) {
            this.fireResistTickLeft = 60;
            return;
        }
        if (this.fireResistTickLeft > 0) {
            --this.fireResistTickLeft;
        }
    }

    private void floatHellhound(AbstractDog dog) {
        if (!dog.m_20077_()) {
            return;
        }
        CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)dog);
        if (collisioncontext.m_6513_(LiquidBlock.f_54690_, dog.m_20183_(), true) && !dog.m_9236_().m_6425_(dog.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
            dog.m_6853_(true);
        } else {
            dog.m_20256_(dog.m_20184_().m_82520_(0.0, 0.085, 0.0));
        }
    }

    private void fireSpreadToEnermies(AbstractDog dog) {
        List targets = dog.m_9236_().m_45976_(LivingEntity.class, dog.m_20191_().m_82377_(3.0, 2.0, 3.0));
        for (LivingEntity x : targets) {
            if (!(x instanceof Enemy)) continue;
            x.m_20254_(5);
        }
    }

    @Override
    public InteractionResultHolder<BlockPathTypes> inferType(AbstractDog dog, BlockPathTypes type) {
        if (this.level < 5) {
            return super.inferType(dog, type);
        }
        if (type == BlockPathTypes.DANGER_FIRE) {
            return InteractionResultHolder.m_19090_((Object)BlockPathTypes.WALKABLE);
        }
        if (type == BlockPathTypes.LAVA) {
            return InteractionResultHolder.m_19090_((Object)BlockPathTypes.BLOCKED);
        }
        return super.inferType(dog, type);
    }
}

