/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.data.GatePasserData;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class GatePasserTalent
extends TalentInstance {
    private boolean allowPassingGate = true;
    private int openDoorCooldown = 0;
    private int keepOpenDoorTick = 0;
    private Optional<BlockPos> currentOpenedDoor = Optional.empty();
    private int navTickLeftTillCanOpenDoor = 20;
    private boolean canApplyBeginNavCooldown = true;

    public GatePasserTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dog) {
        if (dog.m_9236_().f_46443_) {
            return;
        }
        if (!this.allowPassingGate) {
            if (this.currentOpenedDoor.isPresent()) {
                this.currentOpenedDoor = Optional.empty();
            }
            return;
        }
        this.updateNavTickLeftTillCanOpenDoor(dog);
        if (this.openDoorCooldown > 0) {
            --this.openDoorCooldown;
        }
        if (this.keepOpenDoorTick > 0) {
            --this.keepOpenDoorTick;
        }
        if (this.currentOpenedDoor.isPresent()) {
            this.invalidateAndMayCloseOpenedDoor(dog);
        } else {
            this.checkPathForDoorAndTryOpen(dog);
        }
    }

    private void updateNavTickLeftTillCanOpenDoor(AbstractDog dog) {
        PathNavigation nav = dog.m_21573_();
        if (this.canApplyBeginNavCooldown && nav.m_26571_()) {
            this.navTickLeftTillCanOpenDoor = 20;
            this.canApplyBeginNavCooldown = false;
            return;
        }
        --this.navTickLeftTillCanOpenDoor;
        if (this.navTickLeftTillCanOpenDoor < 0) {
            this.navTickLeftTillCanOpenDoor = 0;
        }
    }

    private List<Dog> getNearbyGatePasser(AbstractDog dog) {
        Predicate<Dog> is_passer_and_not_dog = filter_dog -> filter_dog != dog && filter_dog.isDoingFine() && !filter_dog.m_21573_().m_26571_() && filter_dog.getDogLevel((Supplier)DoggyTalents.GATE_PASSER) > 0;
        List passers = dog.m_9236_().m_6443_(Dog.class, dog.m_20191_().m_82400_(1.0), is_passer_and_not_dog);
        return passers;
    }

    private void checkPathForDoorAndTryOpen(AbstractDog dog) {
        if (this.openDoorCooldown > 0) {
            return;
        }
        if (this.navTickLeftTillCanOpenDoor > 0) {
            return;
        }
        PathNavigation nav = dog.m_21573_();
        if (nav.m_26571_()) {
            return;
        }
        Path path = nav.m_26570_();
        if (path == null || path.m_77392_()) {
            return;
        }
        BlockPos doorPos = null;
        BlockState doorState = null;
        Block doorBlock = null;
        Node prevNode = path.m_77402_();
        if (prevNode != null) {
            BlockPos prevPos = prevNode.m_77288_();
            BlockState state = dog.m_9236_().m_8055_(prevPos);
            Block block = state.m_60734_();
            if (this.isValidDoorBlock(block) && !this.isDoorOpen(state, prevPos)) {
                doorState = state;
                doorPos = prevPos;
                doorBlock = block;
            }
        }
        Node nextNode = path.m_77401_();
        if (doorState == null) {
            BlockPos nextPos = nextNode.m_77288_();
            BlockState state = dog.m_9236_().m_8055_(nextPos);
            Block block = state.m_60734_();
            if (this.isValidDoorBlock(block) && !this.isDoorOpen(state, nextPos)) {
                doorState = state;
                doorPos = nextPos;
                doorBlock = block;
            }
        }
        if (doorState == null || doorPos == null || doorBlock == null) {
            return;
        }
        this.currentOpenedDoor = Optional.of(doorPos);
        this.setOpenDoor(dog, doorState, doorPos, true);
        this.canApplyBeginNavCooldown = true;
        this.keepOpenDoorTick = 5;
    }

    private void invalidateAndMayCloseOpenedDoor(AbstractDog dog) {
        if (this.keepOpenDoorTick > 0) {
            return;
        }
        if (!this.currentOpenedDoor.isPresent()) {
            return;
        }
        BlockPos currentOpened = this.currentOpenedDoor.get();
        if (dog.m_20238_(Vec3.m_82539_((Vec3i)currentOpened)) > 16.0) {
            this.currentOpenedDoor = Optional.empty();
            return;
        }
        BlockState state = dog.m_9236_().m_8055_(currentOpened);
        Block block = state.m_60734_();
        if (!this.isValidDoorBlock(block)) {
            this.currentOpenedDoor = Optional.empty();
            return;
        }
        if (!this.isDoorOpen(state, currentOpened)) {
            this.currentOpenedDoor = Optional.empty();
            return;
        }
        if (this.isDogStillPassingThruDoor(dog, currentOpened)) {
            return;
        }
        if (this.mayDelegateClosingDoorToStillPassingDog(dog, currentOpened)) {
            return;
        }
        this.setOpenDoor(dog, state, currentOpened, false);
        this.openDoorCooldown = 5;
        this.currentOpenedDoor = Optional.empty();
    }

    private boolean isDogStillPassingThruDoor(AbstractDog dog, BlockPos doorPos) {
        PathNavigation nav = dog.m_21573_();
        if (nav.m_26571_()) {
            return false;
        }
        Path path = nav.m_26570_();
        if (path == null || path.m_77392_()) {
            return false;
        }
        Node nextNode = path.m_77401_();
        if (nextNode.m_77288_().equals((Object)doorPos)) {
            return true;
        }
        Node prevNextNode = path.m_77402_();
        return prevNextNode != null && prevNextNode.m_77288_().equals((Object)doorPos);
    }

    private boolean mayDelegateClosingDoorToStillPassingDog(AbstractDog delegator, BlockPos doorPos) {
        List<Dog> passers = this.getNearbyGatePasser(delegator);
        if (passers.isEmpty()) {
            return false;
        }
        Dog delegate = null;
        GatePasserTalent delegateInst = null;
        for (Dog dog : passers) {
            TalentInstance inst;
            Optional instOptional;
            if (!dog.isDoingFine() || !this.isDogStillPassingThruDoor(dog, doorPos) || !(instOptional = dog.getTalent((Supplier)DoggyTalents.GATE_PASSER)).isPresent() || !((inst = (TalentInstance)instOptional.get()) instanceof GatePasserTalent)) continue;
            GatePasserTalent gate = (GatePasserTalent)inst;
            delegate = dog;
            delegateInst = gate;
            break;
        }
        if (delegate == null || delegateInst == null) {
            return false;
        }
        delegateInst.currentOpenedDoor = Optional.of(doorPos);
        this.currentOpenedDoor = Optional.empty();
        this.openDoorCooldown = 5;
        return true;
    }

    private boolean isValidDoorBlock(Block block) {
        DoorBlock door;
        return block instanceof DoorBlock && (door = (DoorBlock)block).m_278711_().f_278463_() || block instanceof FenceGateBlock;
    }

    private void setOpenDoor(AbstractDog dog, BlockState state, BlockPos pos, boolean open) {
        Block block = state.m_60734_();
        if (block instanceof DoorBlock) {
            DoorBlock door = (DoorBlock)block;
            door.m_153165_((Entity)dog, dog.m_9236_(), state, pos, open);
            return;
        }
        if (block instanceof FenceGateBlock) {
            FenceGateBlock fenceGate = (FenceGateBlock)block;
            this.setOpenFenceGate(dog.m_9236_(), state, pos, dog, fenceGate, open);
            return;
        }
    }

    private void setOpenFenceGate(Level level, BlockState state, BlockPos pos, AbstractDog dog, FenceGateBlock fence, boolean open) {
        boolean open0 = (Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_);
        boolean hasUpdate = false;
        if (!open && open0) {
            state = (BlockState)state.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(false));
            level.m_7731_(pos, state, 10);
            hasUpdate = true;
        }
        if (open && !open0) {
            Direction direction = dog.m_6350_();
            if (state.m_61143_((Property)FenceGateBlock.f_54117_) == direction.m_122424_()) {
                state = (BlockState)state.m_61124_((Property)FenceGateBlock.f_54117_, (Comparable)direction);
            }
            state = (BlockState)state.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos, state, 10);
            hasUpdate = true;
        }
        if (hasUpdate) {
            boolean still_open = (Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_);
            level.m_245803_((Entity)dog, pos, still_open ? SoundEvents.f_11873_ : SoundEvents.f_11872_, SoundSource.BLOCKS, 1.0f, dog.m_217043_().m_188501_() * 0.1f + 0.9f);
            level.m_142346_((Entity)dog, still_open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        }
    }

    private boolean isDoorOpen(BlockState state, BlockPos pos) {
        Block block = state.m_60734_();
        if (block instanceof DoorBlock) {
            DoorBlock door = (DoorBlock)block;
            return door.m_52815_(state);
        }
        if (block instanceof FenceGateBlock) {
            FenceGateBlock fenceGate = (FenceGateBlock)block;
            return (Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_);
        }
        return false;
    }

    @Override
    public InteractionResult canDogPassGate(AbstractDog dogIn) {
        if (this.allowPassingGate) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.allowPassingGate = compound.m_128471_("DogGatePasser_allowPassingGate");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128379_("DogGatePasser_allowPassingGate", this.allowPassingGate);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf buf) {
        super.writeToBuf(buf);
        buf.writeBoolean(this.allowPassingGate);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf buf) {
        super.readFromBuf(buf);
        this.allowPassingGate = buf.readBoolean();
    }

    @Override
    public void updateOptionsFromServer(TalentInstance fromServer) {
        if (!(fromServer instanceof GatePasserTalent)) {
            return;
        }
        GatePasserTalent gate = (GatePasserTalent)fromServer;
        this.allowPassingGate = gate.allowPassingGate;
    }

    public void updateFromPacket(GatePasserData data) {
        this.allowPassingGate = data.allowPassingGate;
    }

    @Override
    public TalentInstance copy() {
        TalentInstance ret = super.copy();
        if (!(ret instanceof GatePasserTalent)) {
            return ret;
        }
        GatePasserTalent gate = (GatePasserTalent)ret;
        gate.setAllowPassingGate(this.allowPassingGate);
        return gate;
    }

    public boolean allowPassingGate() {
        return this.allowPassingGate;
    }

    public void setAllowPassingGate(boolean val) {
        this.allowPassingGate = val;
    }
}

