/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class OnlineDogLocationManager {
    private final Map<UUID, Dog> onlineDogs = Maps.newHashMap();
    private final ArrayList<UUID> toRemove = new ArrayList();
    private final DogLocationStorage storage;
    private int tickTillUpdateAllOnlineDog = 40;

    public OnlineDogLocationManager(DogLocationStorage storage) {
        this.storage = storage;
    }

    public void tick() {
        if (this.onlineDogs.isEmpty()) {
            return;
        }
        this.invalidateOnlineDogs();
        this.updateAllOnlineDogs();
    }

    private void invalidateOnlineDogs() {
        for (Map.Entry<UUID, Dog> entry : this.onlineDogs.entrySet()) {
            Dog dog = entry.getValue();
            if (!dog.m_213877_()) continue;
            this.toRemove.add(entry.getKey());
        }
        if (this.toRemove.isEmpty()) {
            return;
        }
        for (UUID x : this.toRemove) {
            this.onlineDogs.remove(x);
        }
        this.toRemove.clear();
    }

    public void onDogGoOnline(Dog dog) {
        this.onlineDogs.put(dog.m_20148_(), dog);
    }

    public Optional<Dog> getOnlineDog(UUID dogId) {
        Dog dog = this.onlineDogs.get(dogId);
        if (dog != null && dog.m_213877_()) {
            return Optional.empty();
        }
        return Optional.ofNullable(dog);
    }

    private void updateAllOnlineDogs() {
        if (--this.tickTillUpdateAllOnlineDog > 0) {
            return;
        }
        this.tickTillUpdateAllOnlineDog = 40;
        for (Map.Entry<UUID, Dog> entry : this.onlineDogs.entrySet()) {
            Dog dog = entry.getValue();
            if (dog.m_213877_()) continue;
            this.syncDataToStorage(this.storage, dog);
        }
    }

    private void syncDataToStorage(DogLocationStorage storage, Dog dog) {
        DogLocationData data = storage.getOrCreateData(dog);
        if (data == null) {
            return;
        }
        data.update(dog);
    }

    public void onServerStop() {
        this.unrideAllDogOnPlayer();
        this.onlineDogs.clear();
        this.toRemove.clear();
    }

    private void unrideAllDogOnPlayer() {
        for (Map.Entry<UUID, Dog> entry : this.onlineDogs.entrySet()) {
            Entity vehicle;
            Dog dog = entry.getValue();
            if (dog.m_213877_() || !dog.m_20159_() || !((vehicle = dog.m_20202_()) instanceof Player)) continue;
            dog.m_19877_();
        }
    }
}

