/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Lists;
import doggytalents.DoggyEntityTypes;
import doggytalents.api.feature.EnumMode;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.ai.triggerable.DogDrownAction;
import doggytalents.common.entity.anim.DogAnimation;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.common.util.NBTUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;

public class DogRespawnData
implements IDogData {
    private final DogRespawnStorage storage;
    private final UUID uuid;
    private UUID ownerUUID;
    private CompoundTag data;
    private DogIncapacitatedMananger.IncapacitatedSyncState killedBy = DogIncapacitatedMananger.IncapacitatedSyncState.NONE;
    private static final List<String> TAGS_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"Pos", "Health", "Motion", "Rotation", "FallDistance", "Fire", "Air", "OnGround", "Dimension", "PortalCooldown", "Passengers", "Leash", "InLove", "Leash", "HurtTime", "HurtByTimestamp", "DeathTime", "AbsorptionAmount", "FallFlying", "Brain", "Sitting", "ActiveEffects"});

    protected DogRespawnData(DogRespawnStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    public String getDogName() {
        Component name = NBTUtil.getTextComponent(this.data, "CustomName");
        return name == null ? "noname" : name.getString();
    }

    @Override
    public UUID getOwnerId() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        Component name = NBTUtil.getTextComponent(this.data, "lastKnownOwnerName");
        return name == null ? "" : name.getString();
    }

    public void populate(Dog dogIn) {
        this.data = new CompoundTag();
        dogIn.m_20240_(this.data);
        this.ownerUUID = dogIn.m_21805_();
        Optional<DamageSource> deathCauseOptional = dogIn.getDogDeathCause();
        if (deathCauseOptional.isPresent()) {
            this.killedBy = dogIn.createIncapSyncState(deathCauseOptional.get());
        }
        for (String tag : TAGS_TO_REMOVE) {
            this.data.m_128473_(tag);
        }
        List extraTagsToRemove = (List)ConfigHandler.RESPAWN_TAGS.TAGS_TO_REMOVE.get();
        for (String tag : extraTagsToRemove) {
            this.data.m_128473_(tag);
        }
        this.data.m_128473_("UUID");
        this.data.m_128473_("LoveCause");
        this.data.m_128473_("DTN_DupeDetect_UUID");
    }

    @Nullable
    public Dog respawn(ServerLevel worldIn, Player playerIn, BlockPos pos) {
        Dog dog = (Dog)((EntityType)DoggyEntityTypes.DOG.get()).m_262451_(worldIn, null, null, pos, MobSpawnType.TRIGGERED, true, false);
        if (dog == null) {
            return null;
        }
        CompoundTag compoundnbt = dog.m_20240_(new CompoundTag());
        UUID uuid = dog.m_20148_();
        compoundnbt.m_128391_(this.data);
        dog.m_20258_(compoundnbt);
        boolean useOldUUID = (Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get() == false && worldIn.m_8791_(this.uuid) == null;
        dog.m_20084_(useOldUUID ? this.uuid : uuid);
        dog.m_21839_(true);
        if (this.killedBy != null && this.killedBy != DogIncapacitatedMananger.IncapacitatedSyncState.NONE) {
            if (dog.getDogIncapValue() <= 0) {
                dog.setDogIncapValue(dog.getDefaultInitIncapVal());
            }
            dog.setDogHunger(0.0f);
            dog.setMode(EnumMode.INCAPACITATED);
            dog.m_21153_(1.0f);
            dog.setIncapSyncState(this.killedBy);
            if (dog.m_20069_() || dog.m_20077_()) {
                dog.triggerAnimationAction(new DogDrownAction(dog));
            } else {
                dog.setAnim(dog.incapacitatedMananger.getAnim());
            }
        } else {
            dog.setMode(EnumMode.DOCILE);
            dog.setAnim(DogAnimation.STAND_QUICK);
        }
        worldIn.m_47205_((Entity)dog);
        DogLocationStorage.setSessionUUIDFor(dog, uuid);
        return dog;
    }

    public void read(CompoundTag compound) {
        this.data = compound.m_128469_("data");
        if (compound.m_128403_("owner_uuid")) {
            this.ownerUUID = compound.m_128342_("owner_uuid");
        }
        this.readKilledBy(compound);
    }

    public CompoundTag write(CompoundTag compound) {
        compound.m_128365_("data", (Tag)this.data);
        if (this.ownerUUID != null) {
            compound.m_128362_("owner_uuid", this.ownerUUID);
        }
        this.writeKilledBy(compound);
        return compound;
    }

    public void writeKilledBy(CompoundTag compound) {
        if (this.killedBy == DogIncapacitatedMananger.IncapacitatedSyncState.NONE) {
            return;
        }
        if (this.killedBy == null) {
            return;
        }
        CompoundTag killedByTag = new CompoundTag();
        killedByTag.m_128405_("typeId", this.killedBy.type.getId());
        killedByTag.m_128405_("poseId", this.killedBy.poseId);
        compound.m_128365_("dog_killed_by", (Tag)killedByTag);
    }

    public void readKilledBy(CompoundTag compound) {
        if (!compound.m_128425_("dog_killed_by", 10)) {
            return;
        }
        CompoundTag killedByTag = compound.m_128469_("dog_killed_by");
        int typeId = killedByTag.m_128451_("typeId");
        int poseId = killedByTag.m_128451_("poseId");
        this.killedBy = new DogIncapacitatedMananger.IncapacitatedSyncState(DogIncapacitatedMananger.DefeatedType.byId(typeId), DogIncapacitatedMananger.BandaidState.NONE, poseId);
    }
}

