/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogEatingParticleData;
import doggytalents.common.network.packet.data.DogShakingData;
import doggytalents.common.network.packet.data.ParticleData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ParticlePackets {

    public static class DogShakingPacket
    implements IPacket<DogShakingData> {
        @Override
        public void encode(DogShakingData data, FriendlyByteBuf buf) {
            buf.writeInt(data.dogId);
            buf.writeByte((int)((byte)data.state.getId()));
        }

        @Override
        public DogShakingData decode(FriendlyByteBuf buf) {
            int dogId = buf.readInt();
            DogShakingData.State state = DogShakingData.State.fromId(buf.readByte());
            return new DogShakingData(dogId, state);
        }

        @Override
        public void handle(DogShakingData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    Minecraft mc = Minecraft.m_91087_();
                    Entity e = mc.f_91073_.m_6815_(data.dogId);
                    if (e instanceof Dog) {
                        Dog d = (Dog)e;
                        d.handleDogShakingUpdate(data.state);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendDogShakingPacket(AbstractDog dog, DogShakingData.State state) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> dog), new DogShakingData(dog.m_19879_(), state));
        }
    }

    public static class DogEatingParticlePacket
    implements IPacket<DogEatingParticleData> {
        @Override
        public void encode(DogEatingParticleData data, FriendlyByteBuf buf) {
            buf.writeInt(data.dogId);
            buf.m_130055_(data.food);
        }

        @Override
        public DogEatingParticleData decode(FriendlyByteBuf buf) {
            int dogId = buf.readInt();
            ItemStack food = buf.m_130267_();
            return new DogEatingParticleData(dogId, food);
        }

        @Override
        public void handle(DogEatingParticleData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    Minecraft mc = Minecraft.m_91087_();
                    Entity e = mc.f_91073_.m_6815_(data.dogId);
                    if (e instanceof Dog) {
                        Dog dog = (Dog)e;
                        if (data.food != null) {
                            float a1 = dog.getClientAnimatedYBodyRotInRadians();
                            double dx1 = (double)(-Mth.m_14031_((float)a1)) * ((double)dog.getDogVisualBbWidth() * 1.5);
                            double dz1 = (double)Mth.m_14089_((float)a1) * ((double)dog.getDogVisualBbWidth() * 1.5);
                            for (int i = 0; i < 15; ++i) {
                                double d1 = mc.f_91073_.m_213780_().m_188583_() * 0.5;
                                double d3 = mc.f_91073_.m_213780_().m_188583_() * 0.8;
                                double d5 = mc.f_91073_.m_213780_().m_188583_() * 0.5;
                                double d6 = mc.f_91073_.m_213780_().m_188583_() * 0.1;
                                double d7 = mc.f_91073_.m_213780_().m_188583_() * 0.1;
                                double d8 = mc.f_91073_.m_213780_().m_188583_() * 0.1;
                                mc.f_91073_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, data.food), dog.m_20185_() + dx1 + d1, dog.m_20186_() + (double)dog.m_20192_() + d3, dog.m_20189_() + dz1 + d5, d6, d7, d8);
                            }
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendDogEatingParticlePacketToNearby(AbstractDog dog, ItemStack food) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> dog), new DogEatingParticleData(dog.m_19879_(), food));
        }
    }

    public static class CritEmitterPacket
    implements IPacket<ParticleData.CritEmitterData> {
        @Override
        public void encode(ParticleData.CritEmitterData data, FriendlyByteBuf buf) {
            buf.writeInt(data.targetId);
        }

        @Override
        public ParticleData.CritEmitterData decode(FriendlyByteBuf buf) {
            return new ParticleData.CritEmitterData(buf.readInt());
        }

        @Override
        public void handle(ParticleData.CritEmitterData data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    Minecraft mc = Minecraft.m_91087_();
                    Entity e = mc.f_91073_.m_6815_(data.targetId);
                    if (e != null) {
                        Minecraft.m_91087_().f_91061_.m_107329_(e, (ParticleOptions)ParticleTypes.f_123797_);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendCritEmitterPacketToNearClients(Entity e) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> e), new ParticleData.CritEmitterData(e.m_19879_()));
        }
    }
}

