/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyTalents;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.PackPuppyData;
import doggytalents.common.talent.PackPuppyTalent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PackPuppyPacket
extends DogPacket<PackPuppyData> {
    @Override
    public void encode(PackPuppyData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeInt(data.type.getId());
        buf.writeBoolean(data.val);
    }

    @Override
    public PackPuppyData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        PackPuppyData.Type type = PackPuppyData.Type.fromId(buf.readInt());
        boolean val = buf.readBoolean();
        return new PackPuppyData(entityId, type, val);
    }

    @Override
    public void handleDog(Dog dogIn, PackPuppyData data, Supplier<NetworkEvent.Context> ctx) {
        Optional talentInstOptional = dogIn.getTalent((Supplier)DoggyTalents.PACK_PUPPY);
        if (!talentInstOptional.isPresent()) {
            return;
        }
        TalentInstance talentInst = (TalentInstance)talentInstOptional.get();
        if (!(talentInst instanceof PackPuppyTalent)) {
            return;
        }
        PackPuppyTalent packPup = (PackPuppyTalent)talentInst;
        packPup.updateFromPacket(data);
        dogIn.dogSyncedDataManager.markTalentNeedRefresh(packPup);
    }
}

