/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyTalents;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DoggyTorchData;
import doggytalents.common.talent.DoggyTorchTalent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class DoggyTorchPacket
extends DogPacket<DoggyTorchData> {
    @Override
    public void encode(DoggyTorchData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeInt(data.type.getId());
        buf.writeBoolean(data.val);
    }

    @Override
    public DoggyTorchData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        DoggyTorchData.Type type = DoggyTorchData.Type.fromId(buf.readInt());
        boolean val = buf.readBoolean();
        return new DoggyTorchData(entityId, val, type);
    }

    @Override
    public void handleDog(Dog dogIn, DoggyTorchData data, Supplier<NetworkEvent.Context> ctx) {
        Optional talentInstOptional = dogIn.getTalent((Supplier)DoggyTalents.DOGGY_TORCH);
        if (!talentInstOptional.isPresent()) {
            return;
        }
        TalentInstance talentInst = (TalentInstance)talentInstOptional.get();
        if (!(talentInst instanceof DoggyTorchTalent)) {
            return;
        }
        DoggyTorchTalent torchTalent = (DoggyTorchTalent)talentInst;
        torchTalent.updateFromPacket(data);
        dogIn.dogSyncedDataManager.markTalentNeedRefresh(torchTalent);
    }
}

