/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyTalents;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DoggyToolsPickFirstData;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class DoggyToolsPickFirstPacket
extends DogPacket<DoggyToolsPickFirstData> {
    @Override
    public void encode(DoggyToolsPickFirstData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeBoolean(data.val);
    }

    @Override
    public DoggyToolsPickFirstData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean val = buf.readBoolean();
        return new DoggyToolsPickFirstData(entityId, val);
    }

    @Override
    public void handleDog(Dog dogIn, DoggyToolsPickFirstData data, Supplier<NetworkEvent.Context> ctx) {
        Optional talentInstOptional = dogIn.getTalent((Supplier)DoggyTalents.DOGGY_TOOLS);
        if (!talentInstOptional.isPresent()) {
            return;
        }
        TalentInstance talentInst = (TalentInstance)talentInstOptional.get();
        if (!(talentInst instanceof DoggyToolsTalent)) {
            return;
        }
        DoggyToolsTalent toolsTalent = (DoggyToolsTalent)talentInst;
        toolsTalent.updateFromPacket(data);
        dogIn.dogSyncedDataManager.markTalentNeedRefresh(toolsTalent);
    }
}

