/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogUntameData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DogUntamePacket
extends DogPacket<DogUntameData> {
    @Override
    public DogUntameData decode(FriendlyByteBuf buf) {
        return new DogUntameData(buf.readInt());
    }

    @Override
    public void handleDog(Dog dog, DogUntameData data, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        ItemStack stack = sender.m_21205_();
        if (stack.m_41720_() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (sender.m_36335_().m_41519_((Item)DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.m_21805_();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.m_20148_())) {
            return;
        }
        if (sender.f_36078_ < AmnesiaBoneItem.getUntameXPCost()) {
            return;
        }
        dog.untame();
        sender.m_6749_(-AmnesiaBoneItem.getUntameXPCost());
        dog.m_9236_().m_7605_((Entity)dog, (byte)6);
        CompoundTag tag = stack.m_41784_();
        int usedTime = tag.m_128451_("amnesia_bone_used_time");
        if (++usedTime >= AmnesiaBoneItem.getUseCap()) {
            stack.m_41774_(1);
            sender.m_21166_(EquipmentSlot.MAINHAND);
        }
        tag.m_128405_("amnesia_bone_used_time", usedTime);
        sender.m_36335_().m_41524_((Item)DoggyItems.AMNESIA_BONE.get(), 60);
    }
}

